/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.redis.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class RedisModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/database/redis");
    private static final String REDIS_SECONDARY = "wire/redis/infrastructure/secondary";
    private static final String REFLECTIONS_GROUP = "org.reflections";
    private static final String SPRING_BOOT_GROUP = "org.springframework.boot";
    private final DockerImages dockerImages;

    public RedisModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        String packageName = properties.basePackage().get() + ".";
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Redis"), SOURCE.template("redis.md")).startupCommands().dockerCompose("src/main/docker/redis.yml").and().context().put("redisDockerImage", this.dockerImages.get("redis").fullName()).and().javaDependencies().addDependency(JHipsterModule.groupId(SPRING_BOOT_GROUP), JHipsterModule.artifactId("spring-boot-starter-data-redis")).addDependency(this.reflectionsDependency()).addDependency(this.testContainerDependency()).and().files().add(SOURCE.template("redis.yml"), JHipsterModule.toSrcMainDocker().append("redis.yml")).batch(SOURCE, JHipsterModule.toSrcMainJava().append(packagePath).append(REDIS_SECONDARY)).addTemplate("RedisDatabaseConfiguration.java").addTemplate("JSR310DateConverters.java").and().add(SOURCE.template("JSR310DateConvertersTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(REDIS_SECONDARY).append("JSR310DateConvertersTest.java")).add(SOURCE.template("TestRedisManager.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestRedisManager.java")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.data.redis.database"), JHipsterModule.propertyValue(0)).set(JHipsterModule.propertyKey("spring.data.redis.url"), JHipsterModule.propertyValue("redis://localhost:6379")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.data.redis.url"), JHipsterModule.propertyValue("${TEST_REDIS_URL}")).and().springTestFactories().append(JHipsterModule.propertyKey("org.springframework.context.ApplicationListener"), JHipsterModule.propertyValue(packageName + "TestRedisManager")).and().dockerComposeFile().append(JHipsterModule.dockerComposeFile("src/main/docker/redis.yml")).and().springMainLogger(REFLECTIONS_GROUP, LogLevel.WARN).springMainLogger("org.springframework.data.redis", LogLevel.WARN).springTestLogger(REFLECTIONS_GROUP, LogLevel.WARN).springTestLogger("redis.clients.jedis", LogLevel.WARN).springTestLogger("com.github.dockerjava", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN).build();
    }

    private JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId("testcontainers").versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }

    private JavaDependency reflectionsDependency() {
        return JHipsterModule.javaDependency().groupId(REFLECTIONS_GROUP).artifactId("reflections").versionSlug("reflections").build();
    }
}

