/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.thymeleaf.template.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.thymeleaf.template.application.ThymeleafTemplateModuleApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class ThymeleafTemplateModuleConfiguration {
    private static final String GROUP_SPRING_BOOT_THYMELEAF = "Spring Boot - Thymeleaf";
    private static final String TAG_SERVER = "server";
    private static final String TAG_SPRING = "spring";
    private static final String TAG_BOOT = "spring-boot";
    private static final String TAG_THYMELEAF = "thymeleaf";
    private static final String TAG_TAILWINDCSS = "tailwindcss";
    private static final String TAG_WEBJAR = "webjar";

    ThymeleafTemplateModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource thymeleafTemplateModule(ThymeleafTemplateModuleApplicationService thymeleafTemplate) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.THYMELEAF_TEMPLATE).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(GROUP_SPRING_BOOT_THYMELEAF, "Add thymeleaf skeleton layout files to the project").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.SPRING_BOOT_THYMELEAF).build()).tags(TAG_SERVER, TAG_SPRING, TAG_BOOT, TAG_THYMELEAF).factory(thymeleafTemplate::buildThymeleafTemplateModule);
    }

    @Bean
    JHipsterModuleResource thymeleafTemplateTailwindcssModule(ThymeleafTemplateModuleApplicationService thymeleafTemplate) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.THYMELEAF_TEMPLATE_TAILWINDCSS).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(GROUP_SPRING_BOOT_THYMELEAF, "Add tailwindcss to the thymeleaf template").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.THYMELEAF_TEMPLATE).build()).tags(TAG_SERVER, TAG_SPRING, TAG_BOOT, TAG_THYMELEAF, TAG_TAILWINDCSS).factory(thymeleafTemplate::buildThymeleafTemplateTailwindcssModule);
    }

    @Bean
    JHipsterModuleResource thymeleafTemplateHtmxWebjarsModule(ThymeleafTemplateModuleApplicationService thymeleafTemplate) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.THYMELEAF_TEMPLATE_HTMX_WEBJAR).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(GROUP_SPRING_BOOT_THYMELEAF, "Add htmx webjars scripts to thymeleaf layout").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.HTMX_WEBJARS).addDependency(JHLiteModuleSlug.THYMELEAF_TEMPLATE).build()).tags(TAG_SERVER, TAG_SPRING, TAG_BOOT, TAG_THYMELEAF, TAG_WEBJAR).factory(thymeleafTemplate::buildThymeleafHtmxWebjarsModule);
    }

    @Bean
    JHipsterModuleResource thymeleafTemplateAlpineWebjarsModule(ThymeleafTemplateModuleApplicationService thymeleafTemplate) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.THYMELEAF_TEMPLATE_ALPINEJS_WEBJAR).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(GROUP_SPRING_BOOT_THYMELEAF, "Add alpine webjars scripts to thymeleaf layout").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.ALPINE_JS_WEBJARS).addDependency(JHLiteModuleSlug.THYMELEAF_TEMPLATE).build()).tags(TAG_SERVER, TAG_SPRING, TAG_BOOT, TAG_THYMELEAF, TAG_WEBJAR).factory(thymeleafTemplate::buildThymeleafAlpinejsWebjarsModule);
    }
}

