/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.mavenplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginConfiguration;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecution;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public final class MavenPlugin {
    private final DependencyId dependencyId;
    private final Optional<VersionSlug> versionSlug;
    private final Optional<MavenPluginConfiguration> configuration;
    private final Collection<MavenPluginExecution> executions;
    private final Collection<JavaDependency> dependencies;

    private MavenPlugin(MavenPluginBuilder builder) {
        Assert.notNull("executions", builder.executions);
        Assert.notNull("dependencies", builder.dependencies);
        this.dependencyId = DependencyId.of(builder.groupId, builder.artifactId);
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
        this.configuration = Optional.ofNullable(builder.configuration);
        this.executions = builder.executions;
        this.dependencies = builder.dependencies;
    }

    public static MavenPluginGroupIdBuilder builder() {
        return new MavenPluginBuilder();
    }

    public Optional<VersionSlug> versionSlug() {
        return this.versionSlug;
    }

    public Optional<MavenPluginConfiguration> configuration() {
        return this.configuration;
    }

    public Collection<MavenPluginExecution> executions() {
        return this.executions;
    }

    public DependencyId dependencyId() {
        return this.dependencyId;
    }

    public Collection<JavaDependency> dependencies() {
        return this.dependencies;
    }

    @ExcludeFromGeneratedCodeCoverage
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dependencyId", (Object)this.dependencyId).append("versionSlug", (Object)this.versionSlug.map(VersionSlug::toString).orElse("")).append("configuration", (Object)this.configuration.map(MavenPluginConfiguration::toString).orElse("")).append("executions", this.executions).append("dependencies", this.dependencies);
        return builder.toString();
    }

    private static final class MavenPluginBuilder
    implements MavenPluginGroupIdBuilder,
    MavenPluginArtifactIdBuilder,
    MavenPluginOptionalBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private VersionSlug versionSlug;
        private MavenPluginConfiguration configuration;
        private final List<MavenPluginExecution> executions = new ArrayList<MavenPluginExecution>();
        private final Collection<JavaDependency> dependencies = new LinkedHashSet<JavaDependency>();

        private MavenPluginBuilder() {
        }

        @Override
        public MavenPluginArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public MavenPluginOptionalBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public MavenPluginOptionalBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public MavenPluginOptionalBuilder configuration(MavenPluginConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public MavenPluginOptionalBuilder addExecution(MavenPluginExecution executions) {
            this.executions.add(executions);
            return this;
        }

        @Override
        public MavenPluginOptionalBuilder addDependency(JavaDependency dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        @Override
        public MavenPlugin build() {
            return new MavenPlugin(this);
        }
    }

    public static interface MavenPluginOptionalBuilder {
        public MavenPluginOptionalBuilder versionSlug(VersionSlug var1);

        public MavenPlugin build();

        default public MavenPluginOptionalBuilder versionSlug(String slug) {
            return this.versionSlug(new VersionSlug(slug));
        }

        public MavenPluginOptionalBuilder configuration(MavenPluginConfiguration var1);

        default public MavenPluginOptionalBuilder configuration(String configuration) {
            return this.configuration(new MavenPluginConfiguration(configuration));
        }

        public MavenPluginOptionalBuilder addExecution(MavenPluginExecution var1);

        default public MavenPluginOptionalBuilder addExecution(MavenPluginExecution.MavenPluginExecutionOptionalBuilder builder) {
            return this.addExecution(builder.build());
        }

        public MavenPluginOptionalBuilder addDependency(JavaDependency var1);

        default public MavenPluginOptionalBuilder addDependency(GroupId groupId, ArtifactId artifactId, VersionSlug version) {
            return this.addDependency(JavaDependency.builder().groupId(groupId).artifactId(artifactId).versionSlug(version).build());
        }
    }

    public static interface MavenPluginArtifactIdBuilder {
        public MavenPluginOptionalBuilder artifactId(ArtifactId var1);

        default public MavenPluginOptionalBuilder artifactId(String artifactId) {
            return this.artifactId(new ArtifactId(artifactId));
        }
    }

    public static interface MavenPluginGroupIdBuilder {
        public MavenPluginArtifactIdBuilder groupId(GroupId var1);

        default public MavenPluginArtifactIdBuilder groupId(String groupId) {
            return this.groupId(new GroupId(groupId));
        }
    }
}

