/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.npm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import tech.jhipster.lite.module.domain.npm.NpmPackage;
import tech.jhipster.lite.module.domain.npm.NpmPackageName;
import tech.jhipster.lite.module.domain.npm.NpmPackageVersion;
import tech.jhipster.lite.module.domain.npm.NpmVersionSource;
import tech.jhipster.lite.module.domain.npm.UnknownNpmPackageException;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class NpmPackagesVersions {
    public static final NpmPackagesVersions EMPTY = NpmPackagesVersions.builder().build();
    private final Map<NpmVersionSource, NpmSourceVersions> versions;

    private NpmPackagesVersions(NpmPackagesVersionsBuilder builder) {
        this.versions = Collections.unmodifiableMap(builder.versions);
    }

    private NpmPackagesVersions(Map<NpmVersionSource, NpmSourceVersions> versions) {
        this.versions = Collections.unmodifiableMap(versions);
    }

    public static NpmPackagesVersionsBuilder builder() {
        return new NpmPackagesVersionsBuilder();
    }

    public NpmPackageVersion get(NpmPackageName packageName, NpmVersionSource source) {
        Assert.notNull("packageName", packageName);
        Assert.notNull("source", source);
        return Optional.ofNullable(this.versions.get(source)).orElseThrow(() -> new UnknownNpmPackageException(packageName, source)).get(packageName);
    }

    public NpmPackagesVersions merge(NpmPackagesVersions other) {
        Assert.notNull("other", other);
        HashMap<NpmVersionSource, NpmSourceVersions> mergedVersions = new HashMap<NpmVersionSource, NpmSourceVersions>();
        other.versions.forEach((source, packages) -> mergedVersions.computeIfAbsent((NpmVersionSource)source, NpmSourceVersions::new).add((NpmSourceVersions)packages));
        this.versions.forEach((source, packages) -> mergedVersions.computeIfAbsent((NpmVersionSource)source, NpmSourceVersions::new).add((NpmSourceVersions)packages));
        return new NpmPackagesVersions(mergedVersions);
    }

    public static class NpmPackagesVersionsBuilder {
        private final Map<NpmVersionSource, NpmSourceVersions> versions = new ConcurrentHashMap<NpmVersionSource, NpmSourceVersions>();

        public NpmPackagesVersionsBuilder put(NpmVersionSource source, Collection<NpmPackage> packages) {
            this.versions.computeIfAbsent(source, key -> new NpmSourceVersions(source)).add(packages);
            return this;
        }

        public NpmPackagesVersions build() {
            return new NpmPackagesVersions(this);
        }
    }

    private static final class NpmSourceVersions {
        private final NpmVersionSource source;
        private final Map<NpmPackageName, NpmPackageVersion> versions = new ConcurrentHashMap<NpmPackageName, NpmPackageVersion>();

        private NpmSourceVersions(NpmVersionSource source) {
            Assert.notNull("source", source);
            this.source = source;
        }

        private void add(NpmSourceVersions packages) {
            this.versions.putAll(packages.versions);
        }

        private void add(Collection<NpmPackage> packages) {
            Assert.field("packages", packages).notNull().noNullElement();
            this.versions.putAll(packages.stream().collect(Collectors.toMap(NpmPackage::name, NpmPackage::version)));
        }

        private NpmPackageVersion get(NpmPackageName packageName) {
            return Optional.ofNullable(this.versions.get(packageName)).orElseThrow(() -> new UnknownNpmPackageException(packageName, this.source));
        }
    }
}

