/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.properties;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Map;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.javadependency.Version;
import tech.jhipster.lite.module.domain.properties.InvalidPropertyTypeException;
import tech.jhipster.lite.module.domain.properties.JHipsterBasePackage;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleParameters;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectBaseName;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectName;
import tech.jhipster.lite.module.domain.properties.JHipsterServerPort;
import tech.jhipster.lite.module.domain.properties.SpringConfigurationFormat;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleProperties {
    public static final String BASE_PACKAGE_PARAMETER = "packageName";
    public static final String INDENTATION_PARAMETER = "indentSize";
    public static final String PROJECT_NAME_PARAMETER = "projectName";
    public static final String PROJECT_BASE_NAME_PARAMETER = "baseName";
    public static final String SERVER_PORT_PARAMETER = "serverPort";
    public static final String SPRING_CONFIGURATION_FORMAT = "springConfigurationFormat";
    public static final String JAVA_VERSION = "javaVersion";
    public static final String JAVA_BUILD_TOOL = "javaBuildTool";
    public static final String PROJECT_BUILD_DIRECTORY = "projectBuildDirectory";
    private final JHipsterProjectFolder projectFolder;
    private final boolean commitModule;
    private final JHipsterModuleParameters parameters;
    private final Indentation indentation;
    private final JHipsterBasePackage basePackage;
    private final JHipsterProjectName projectName;
    private final JHipsterProjectBaseName projectBaseName;
    private final JHipsterServerPort serverPort;
    private final SpringConfigurationFormat springConfigurationFormat;
    private final Version javaVersion = new Version("21");

    public JHipsterModuleProperties(String projectFolder, boolean commitModule, Map<String, Object> parameters) {
        this.projectFolder = new JHipsterProjectFolder(projectFolder);
        this.commitModule = commitModule;
        this.parameters = new JHipsterModuleParameters(parameters);
        this.indentation = Indentation.from(this.parameters.getOrDefault(INDENTATION_PARAMETER, null, Integer.class));
        this.basePackage = new JHipsterBasePackage(this.parameters.getOrDefault(BASE_PACKAGE_PARAMETER, null, String.class));
        this.projectName = new JHipsterProjectName(this.parameters.getOrDefault(PROJECT_NAME_PARAMETER, null, String.class));
        this.projectBaseName = new JHipsterProjectBaseName(this.parameters.getOrDefault(PROJECT_BASE_NAME_PARAMETER, null, String.class));
        this.serverPort = new JHipsterServerPort(this.parameters.getOrDefault(SERVER_PORT_PARAMETER, null, Integer.class));
        this.springConfigurationFormat = SpringConfigurationFormat.from(this.parameters.getOrDefault(SPRING_CONFIGURATION_FORMAT, SpringConfigurationFormat.YAML.get(), String.class));
    }

    public JHipsterProjectFolder projectFolder() {
        return this.projectFolder;
    }

    public boolean commitNeeded() {
        return this.commitModule;
    }

    public Version javaVersion() {
        return this.javaVersion;
    }

    public String getString(String key) {
        return this.parameters.get(key, String.class);
    }

    public String getOrDefaultString(String key, String defaultValue) {
        Assert.notBlank("defaultValue", defaultValue);
        return this.parameters.getOrDefault(key, defaultValue, String.class, String::isBlank);
    }

    public Instant getInstantOrDefault(String key, Instant defaultValue) {
        String date = this.getOrDefaultString(key, defaultValue.toString());
        try {
            return Instant.parse(date);
        }
        catch (DateTimeParseException ex) {
            throw InvalidPropertyTypeException.builder().key(key).expectedType(Instant.class).actualType(String.class);
        }
    }

    public boolean getBoolean(String key) {
        return this.parameters.get(key, Boolean.class);
    }

    public boolean getOrDefaultBoolean(String key, boolean defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue, Boolean.class);
    }

    public int getInteger(String key) {
        return this.parameters.get(key, Integer.class);
    }

    public int getOrDefaultInteger(String key, int defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue, Integer.class);
    }

    public Indentation indentation() {
        return this.indentation;
    }

    public String packagePath() {
        return this.basePackage.path();
    }

    public JHipsterBasePackage basePackage() {
        return this.basePackage;
    }

    public JHipsterProjectName projectName() {
        return this.projectName;
    }

    public JHipsterProjectBaseName projectBaseName() {
        return this.projectBaseName;
    }

    public JHipsterServerPort serverPort() {
        return this.serverPort;
    }

    public SpringConfigurationFormat springConfigurationFormat() {
        return this.springConfigurationFormat;
    }

    public Map<String, Object> getParameters() {
        return this.parameters.get();
    }

    public String toString() {
        return String.valueOf(this.projectName);
    }
}

