/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.shared.error.domain.Assert;

public record TextNeedleBeforeReplacer(ReplacementCondition condition, String text) implements ElementReplacer
{
    public TextNeedleBeforeReplacer {
        Assert.notNull("condition", condition);
        Assert.notBlank("text", text);
    }

    @Override
    public boolean notMatchIn(String content) {
        Assert.notNull("content", content);
        return !content.contains(this.text());
    }

    @Override
    public BiFunction<String, String, String> replacement() {
        return (content, replacement) -> {
            List<Integer> needlesLinesIndexes = this.needlesLinesIndexes((String)content);
            if (needlesLinesIndexes.isEmpty()) {
                return content;
            }
            String replacementBlock = replacement + "\n";
            return String.join((CharSequence)replacementBlock, this.buildBlocks((String)content, needlesLinesIndexes));
        };
    }

    private List<Integer> needlesLinesIndexes(String content) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int textIndex = content.indexOf(this.text());
        while (textIndex != -1) {
            indexes.add(this.lineIndex(content, textIndex));
            textIndex = content.indexOf(this.text(), textIndex + this.text().length());
        }
        return indexes;
    }

    private int lineIndex(String content, int textIndex) {
        int index = content.substring(0, textIndex).lastIndexOf("\n");
        if (index == -1) {
            return 0;
        }
        return index + 1;
    }

    private List<String> buildBlocks(String content, List<Integer> needlesLinesIndexes) {
        ArrayList<String> blocks = new ArrayList<String>();
        for (int index = 0; index < needlesLinesIndexes.size(); ++index) {
            blocks.add(content.substring(this.blockStart(needlesLinesIndexes, index), needlesLinesIndexes.get(index)));
        }
        blocks.add(content.substring(needlesLinesIndexes.getLast()));
        return blocks;
    }

    private int blockStart(List<Integer> needlesLinesIndexes, int index) {
        if (index == 0) {
            return 0;
        }
        return needlesLinesIndexes.get(index - 1);
    }

    @Override
    public String searchMatcher() {
        return this.text();
    }
}

