/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.infrastructure.primary.InvalidProjectFolderException;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.projectfolder.domain.ProjectFolder;

class RestJHipsterModuleProperties {
    private final String projectFolder;
    private final boolean commit;
    private final Map<String, Object> parameters;

    RestJHipsterModuleProperties(@JsonProperty(value="projectFolder") String projectFolder, @JsonProperty(value="commit") boolean commit, @JsonProperty(value="parameters") Map<String, Object> parameters) {
        this.projectFolder = projectFolder;
        this.commit = commit;
        this.parameters = parameters;
    }

    public JHipsterModuleProperties toDomain(ProjectFolder jHipsterProjectFolderFactory) {
        Assert.notNull("jHipsterProjectFolderFactory", jHipsterProjectFolderFactory);
        this.assertValidProjectFolder(jHipsterProjectFolderFactory);
        return new JHipsterModuleProperties(this.getProjectFolder(), this.isCommit(), this.getParameters());
    }

    private void assertValidProjectFolder(ProjectFolder jHipsterProjectFolderFactory) {
        if (jHipsterProjectFolderFactory.isInvalid(this.projectFolder)) {
            throw new InvalidProjectFolderException(this.projectFolder);
        }
    }

    @Schema(description="Path to the project folder", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getProjectFolder() {
        return this.projectFolder;
    }

    @Schema(description="True to commit each module application, false otherwise", requiredMode=Schema.RequiredMode.REQUIRED)
    public boolean isCommit() {
        return this.commit;
    }

    @Schema(description="Parameters to apply on modules")
    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

