/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle;

import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.buildproperties.BuildProperty;
import tech.jhipster.lite.module.domain.buildproperties.PropertyKey;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterFileContent;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFile;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFiles;
import tech.jhipster.lite.module.domain.gradleplugin.BuildGradleImport;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityProfilePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCorePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginConfiguration;
import tech.jhipster.lite.module.domain.javabuild.DependencySlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradleConfiguration;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradleTasksTestInstruction;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileActivation;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.ContentReplacers;
import tech.jhipster.lite.module.domain.replacement.MandatoryFileReplacer;
import tech.jhipster.lite.module.domain.replacement.MandatoryReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemJHipsterModuleFiles;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemReplacer;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.GradleDependencyScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.MissingGradleProfileException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.VersionsCatalog;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public class GradleCommandHandler
implements JavaDependenciesCommandHandler {
    private static final String COMMAND = "command";
    private static final String BUILD_GRADLE_FILE = "build.gradle.kts";
    private static final String PLUGIN_BUILD_GRADLE_FILE = "buildSrc/build.gradle.kts";
    private static final Pattern GRADLE_IMPORT_NEEDLE = Pattern.compile("^// jhipster-needle-gradle-imports$", 8);
    private static final Pattern GRADLE_PLUGIN_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-plugins$", 8);
    private static final Pattern GRADLE_PLUGIN_PROJECT_EXTENSION_CONFIGURATION_NEEDLE = Pattern.compile("^// jhipster-needle-gradle-plugins-configurations$", 8);
    private static final Pattern GRADLE_IMPLEMENTATION_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-implementation-dependencies$", 8);
    private static final Pattern GRADLE_COMPILE_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-compile-dependencies$", 8);
    private static final Pattern GRADLE_RUNTIME_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-runtime-dependencies$", 8);
    private static final Pattern GRADLE_TEST_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-test-dependencies$", 8);
    private static final Pattern GRADLE_PROFILE_ACTIVATION_NEEDLE = Pattern.compile("^// jhipster-needle-profile-activation$", 8);
    private static final Pattern GRADLE_PROPERTY_NEEDLE = Pattern.compile("^// jhipster-needle-gradle-properties$", 8);
    private static final Pattern GRADLE_FREE_CONFIGURATION_BLOCKS_NEEDLE = Pattern.compile("^// jhipster-needle-gradle-free-configuration-blocks$", 8);
    private static final Pattern GRADLE_TASKS_TEST_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-tasks-test$", 8);
    private static final String PROFILE_CONDITIONAL_TEMPLATE = "if (profiles.contains(\"%s\")) {\n  apply(plugin = \"profile-%s\")\n}";
    private static final String PROFILE_DEFAULT_ACTIVATION_CONDITIONAL_TEMPLATE = "if (profiles.isEmpty() || profiles.contains(\"%s\")) {\n  apply(plugin = \"profile-%s\")\n}";
    private static final String BUILD_GRADLE_PROFILE_PATH_TEMPLATE = "buildSrc/src/main/kotlin/profile-%s.gradle.kts";
    private final Indentation indentation;
    private final JHipsterProjectFolder projectFolder;
    private final JHipsterModuleContext context;
    private final VersionsCatalog versionsCatalog;
    private final FileSystemReplacer fileReplacer;
    private final FileSystemJHipsterModuleFiles files;

    public GradleCommandHandler(Indentation indentation, JHipsterProjectFolder projectFolder, JHipsterModuleContext context, FileSystemJHipsterModuleFiles files, FileSystemReplacer fileReplacer) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("context", context);
        this.indentation = indentation;
        this.projectFolder = projectFolder;
        this.context = context;
        this.versionsCatalog = new VersionsCatalog(projectFolder);
        this.fileReplacer = fileReplacer;
        this.files = files;
    }

    @Override
    public void handle(SetVersion command) {
        Assert.notNull(COMMAND, command);
        this.versionsCatalog.setVersion(command.version());
    }

    @Override
    public void handle(AddDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        this.versionsCatalog.addLibrary(command.dependency());
        this.addDependencyToBuildGradle(command.dependency(), this.buildGradleFile(command.buildProfile()), command.buildProfile().isPresent());
    }

    private void addDependencyToBuildGradle(JavaDependency dependency, Path buildGradleFile, boolean forBuildProfile) {
        GradleDependencyScope gradleScope = GradleCommandHandler.gradleDependencyScope(dependency);
        String dependencyDeclaration = this.dependencyDeclaration(dependency, forBuildProfile);
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), this.needleForGradleDependencyScope(gradleScope)), dependencyDeclaration);
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(buildGradleFile), replacer)), this.context);
    }

    private Pattern needleForGradleDependencyScope(GradleDependencyScope gradleScope) {
        return switch (gradleScope) {
            default -> throw new MatchException(null, null);
            case GradleDependencyScope.IMPLEMENTATION -> GRADLE_IMPLEMENTATION_DEPENDENCY_NEEDLE;
            case GradleDependencyScope.COMPILE_ONLY -> GRADLE_COMPILE_DEPENDENCY_NEEDLE;
            case GradleDependencyScope.RUNTIME_ONLY -> GRADLE_RUNTIME_DEPENDENCY_NEEDLE;
            case GradleDependencyScope.TEST_IMPLEMENTATION -> GRADLE_TEST_DEPENDENCY_NEEDLE;
        };
    }

    private String dependencyDeclaration(JavaDependency dependency, boolean forBuildProfile) {
        String versionCatalogReference;
        StringBuilder dependencyDeclaration = new StringBuilder().append(this.indentation.times(1)).append(GradleCommandHandler.gradleDependencyScope(dependency).command()).append("(");
        String string = versionCatalogReference = forBuildProfile ? GradleCommandHandler.versionCatalogReferenceForBuildProfile(dependency) : GradleCommandHandler.versionCatalogReference(dependency);
        if (dependency.scope() == JavaDependencyScope.IMPORT) {
            dependencyDeclaration.append("platform(%s)".formatted(versionCatalogReference));
        } else {
            dependencyDeclaration.append(versionCatalogReference);
        }
        dependencyDeclaration.append(")");
        if (!dependency.exclusions().isEmpty()) {
            dependencyDeclaration.append(" {");
            for (DependencyId exclusion : dependency.exclusions()) {
                dependencyDeclaration.append("\n");
                dependencyDeclaration.append(this.indentation.times(2)).append("exclude(group = \"%s\", module = \"%s\")".formatted(exclusion.groupId(), exclusion.artifactId()));
            }
            dependencyDeclaration.append("\n");
            dependencyDeclaration.append(this.indentation.times(1)).append("}");
        }
        return dependencyDeclaration.toString();
    }

    private static String versionCatalogReferenceForBuildProfile(JavaDependency dependency) {
        return "libs.findLibrary(\"%s\").get()".formatted(GradleCommandHandler.applyVersionCatalogReferenceConvention(VersionsCatalog.libraryAlias(dependency)));
    }

    private static String versionCatalogReference(JavaDependency dependency) {
        return "libs.%s".formatted(GradleCommandHandler.applyVersionCatalogReferenceConvention(VersionsCatalog.libraryAlias(dependency)));
    }

    private static String applyVersionCatalogReferenceConvention(String rawVersionCatalogReference) {
        return rawVersionCatalogReference.replace("-", ".");
    }

    private static GradleDependencyScope gradleDependencyScope(JavaDependency dependency) {
        return switch (dependency.scope()) {
            case JavaDependencyScope.TEST -> GradleDependencyScope.TEST_IMPLEMENTATION;
            case JavaDependencyScope.PROVIDED -> GradleDependencyScope.COMPILE_ONLY;
            case JavaDependencyScope.RUNTIME -> GradleDependencyScope.RUNTIME_ONLY;
            default -> GradleDependencyScope.IMPLEMENTATION;
        };
    }

    @Override
    public void handle(RemoveDirectJavaDependency command) {
        this.versionsCatalog.retrieveDependencySlugsFrom(command.dependency()).stream().filter(this.dependencyExistsFrom(command.buildProfile())).forEach(dependencySlug -> {
            this.removeDependencyFromBuildGradle((DependencySlug)dependencySlug, command.buildProfile());
            this.versionsCatalog.removeLibrary(command.dependency());
        });
    }

    private Predicate<DependencySlug> dependencyExistsFrom(Optional<BuildProfileId> buildProfile) {
        return dependencySlug -> {
            String buildGradleFileContent = this.readContent(this.buildGradleFile(buildProfile));
            return this.dependencyLinePattern((DependencySlug)dependencySlug, buildProfile).matcher(buildGradleFileContent).find();
        };
    }

    @ExcludeFromGeneratedCodeCoverage(reason="IOException is hard to test")
    private String readContent(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error reading file " + String.valueOf(path) + ": " + e.getMessage(), e);
        }
    }

    private void removeDependencyFromBuildGradle(DependencySlug dependencySlug, Optional<BuildProfileId> buildProfile) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexReplacer(ReplacementCondition.always(), this.dependencyLinePattern(dependencySlug, buildProfile)), "");
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(this.buildGradleFile(buildProfile)), replacer)), this.context);
    }

    private Pattern dependencyLinePattern(DependencySlug dependencySlug, Optional<BuildProfileId> buildProfile) {
        String scopePattern = Stream.of(GradleDependencyScope.values()).map(GradleDependencyScope::command).collect(Collectors.joining("|", "(?:", ")"));
        String libsPattern = buildProfile.isPresent() ? "libs\\.findLibrary\\(\"%s\"\\)\\.get\\(\\)" : "libs\\.%s";
        return Pattern.compile("^\\s+%s\\((?:platform\\()?%s\\)?\\)(?:\\s+\\{(?:\\s+exclude\\([^)]*\\))+\\s+\\})?$".formatted(scopePattern, libsPattern.formatted(dependencySlug.slug().replace("-", "\\."))), 8);
    }

    @Override
    public void handle(RemoveJavaDependencyManagement command) {
        this.versionsCatalog.retrieveDependencySlugsFrom(command.dependency()).stream().filter(this.dependencyExistsFrom(command.buildProfile())).forEach(dependencySlug -> {
            this.removeDependencyFromBuildGradle((DependencySlug)dependencySlug, command.buildProfile());
            this.versionsCatalog.removeLibrary(command.dependency());
        });
    }

    @Override
    public void handle(AddJavaDependencyManagement command) {
        this.versionsCatalog.addLibrary(command.dependency());
        this.addDependencyToBuildGradle(command.dependency(), this.buildGradleFile(command.buildProfile()), command.buildProfile().isPresent());
    }

    @Override
    public void handle(AddDirectMavenPlugin command) {
    }

    @Override
    public void handle(AddMavenPluginManagement command) {
    }

    @Override
    public void handle(SetBuildProperty command) {
        Assert.notNull(COMMAND, command);
        this.addPropertyTo(command.property(), this.buildGradleFile(command.buildProfile()));
    }

    private Path buildGradleFile(Optional<BuildProfileId> buildProfile) {
        return buildProfile.map(buildProfileId -> {
            File scriptPlugin = this.scriptPluginForProfile((BuildProfileId)buildProfileId);
            if (!scriptPlugin.exists()) {
                throw new MissingGradleProfileException((BuildProfileId)buildProfileId);
            }
            return scriptPlugin.toPath();
        }).orElse(this.projectFolder.filePath(BUILD_GRADLE_FILE));
    }

    private void addPropertyTo(BuildProperty property, Path buildGradleFile) {
        MandatoryReplacer replacer = this.propertyExistsFrom(property.key(), buildGradleFile) ? this.existingPropertyReplacer(property) : GradleCommandHandler.addNewPropertyReplacer(property);
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(buildGradleFile), replacer)), this.context);
    }

    private JHipsterProjectFilePath projectFolderRelativePathFrom(Path buildGradleFile) {
        return new JHipsterProjectFilePath(Path.of(this.projectFolder.folder(), new String[0]).relativize(buildGradleFile).toString());
    }

    private MandatoryReplacer existingPropertyReplacer(BuildProperty property) {
        Pattern propertyLinePattern = Pattern.compile("val %s by extra\\(\"(.*?)\"\\)".formatted(GradleCommandHandler.toCamelCasedKotlinVariable(property.key())), 8);
        return new MandatoryReplacer(JHipsterModule.regex(ReplacementCondition.notMatchingRegex(propertyLinePattern), propertyLinePattern), GradleCommandHandler.convertToKotlinFormat(property));
    }

    private static MandatoryReplacer addNewPropertyReplacer(BuildProperty property) {
        return new MandatoryReplacer(new RegexNeedleBeforeReplacer(ReplacementCondition.always(), GRADLE_PROPERTY_NEEDLE), GradleCommandHandler.convertToKotlinFormat(property));
    }

    private static String convertToKotlinFormat(BuildProperty property) {
        return "val %s by extra(\"%s\")".formatted(GradleCommandHandler.toCamelCasedKotlinVariable(property.key()), property.value().get());
    }

    private static String toCamelCasedKotlinVariable(PropertyKey key) {
        return Arrays.stream(key.get().split("[.-]")).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.collectingAndThen(Collectors.joining(), str -> str.substring(0, 1).toLowerCase(Locale.ROOT) + str.substring(1)));
    }

    private boolean propertyExistsFrom(PropertyKey key, Path buildGradleFile) {
        String content = this.readContent(buildGradleFile);
        return content.contains("val %s by extra(".formatted(GradleCommandHandler.toCamelCasedKotlinVariable(key)));
    }

    @Override
    public void handle(AddMavenBuildExtension command) {
    }

    @Override
    public void handle(AddJavaBuildProfile command) {
        Assert.notNull(COMMAND, command);
        this.enablePrecompiledScriptPlugins();
        File scriptPlugin = this.scriptPluginForProfile(command.buildProfileId());
        if (!scriptPlugin.exists()) {
            this.addProfileActivation(command);
            this.addScriptPluginForProfile(command.buildProfileId());
        }
    }

    private void enablePrecompiledScriptPlugins() {
        this.addFileToProject(JHipsterModule.from("buildtool/gradle/buildSrc/build.gradle.kts.mustache"), JHipsterModule.to(PLUGIN_BUILD_GRADLE_FILE));
        this.addFileToProject(JHipsterModule.from("buildtool/gradle/buildSrc/settings.gradle.kts.mustache"), JHipsterModule.to("buildSrc/settings.gradle.kts"));
    }

    private File scriptPluginForProfile(BuildProfileId buildProfileId) {
        return this.projectFolder.filePath(BUILD_GRADLE_PROFILE_PATH_TEMPLATE.formatted(buildProfileId.value())).toFile();
    }

    private void addProfileActivation(AddJavaBuildProfile command) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer(ReplacementCondition.always(), GRADLE_PROFILE_ACTIVATION_NEEDLE), GradleCommandHandler.fillProfileActivationTemplate(command));
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)), this.context);
    }

    private static String fillProfileActivationTemplate(AddJavaBuildProfile command) {
        Optional isActiveByDefault = command.activation().flatMap(BuildProfileActivation::activeByDefault);
        return (isActiveByDefault.orElse(false) != false ? PROFILE_DEFAULT_ACTIVATION_CONDITIONAL_TEMPLATE : PROFILE_CONDITIONAL_TEMPLATE).formatted(command.buildProfileId(), command.buildProfileId());
    }

    private void addScriptPluginForProfile(BuildProfileId buildProfileId) {
        this.addFileToProject(JHipsterModule.from("buildtool/gradle/buildSrc/src/main/kotlin/profile.gradle.kts.mustache"), JHipsterModule.to(BUILD_GRADLE_PROFILE_PATH_TEMPLATE.formatted(buildProfileId)));
    }

    private void addFileToProject(JHipsterSource source, JHipsterDestination destination) {
        if (this.projectFolder.fileExists(destination.get())) {
            return;
        }
        this.files.create(this.projectFolder, new JHipsterTemplatedFiles(List.of(JHipsterTemplatedFile.builder().file(new JHipsterModuleFile(new JHipsterFileContent(source), destination, false)).context(this.context).build())));
    }

    @Override
    public void handle(AddGradlePlugin command) {
        Assert.notNull(COMMAND, command);
        GradlePlugin gradlePlugin = command.plugin();
        Objects.requireNonNull(gradlePlugin);
        GradlePlugin gradlePlugin2 = gradlePlugin;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GradleCorePlugin.class, GradleCommunityPlugin.class, GradleCommunityProfilePlugin.class}, (Object)gradlePlugin2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GradleCorePlugin plugin = (GradleCorePlugin)gradlePlugin2;
                this.declarePlugin(plugin.id().get(), command.buildProfile());
                break;
            }
            case 1: {
                GradleCommunityPlugin plugin = (GradleCommunityPlugin)gradlePlugin2;
                this.declarePlugin("alias(libs.plugins.%s)".formatted(GradleCommandHandler.applyVersionCatalogReferenceConvention(VersionsCatalog.pluginAlias(plugin))), command.buildProfile());
                this.versionsCatalog.addPlugin(plugin);
                break;
            }
            case 2: {
                GradleCommunityProfilePlugin plugin = (GradleCommunityProfilePlugin)gradlePlugin2;
                this.declarePlugin("id(\"%s\")".formatted(plugin.id().get()), command.buildProfile());
                this.versionsCatalog.addLibrary(this.dependencyFrom(plugin));
                this.addDependencyToBuildGradle(this.dependencyFrom(plugin), this.projectFolder.filePath(PLUGIN_BUILD_GRADLE_FILE), false);
            }
        }
        command.plugin().imports().forEach(pluginImport -> this.addPluginImport((BuildGradleImport)pluginImport, command.buildProfile()));
        command.plugin().configuration().ifPresent(pluginConfiguration -> this.addPluginConfiguration((GradlePluginConfiguration)pluginConfiguration, command.buildProfile()));
        command.toolVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
    }

    private void declarePlugin(String pluginDeclaration, Optional<BuildProfileId> buildProfile) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_PLUGIN_NEEDLE), this.indentation.times(1) + pluginDeclaration);
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(this.buildGradleFile(buildProfile)), replacer)), this.context);
    }

    private void addPluginImport(BuildGradleImport gradleImport, Optional<BuildProfileId> buildProfile) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_IMPORT_NEEDLE), "import %s".formatted(gradleImport.get()));
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(this.buildGradleFile(buildProfile)), replacer)), this.context);
    }

    private void addPluginConfiguration(GradlePluginConfiguration pluginConfiguration, Optional<BuildProfileId> buildProfile) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_PLUGIN_PROJECT_EXTENSION_CONFIGURATION_NEEDLE), "\n" + pluginConfiguration.get());
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(this.projectFolderRelativePathFrom(this.buildGradleFile(buildProfile)), replacer)), this.context);
    }

    private JavaDependency dependencyFrom(GradleCommunityProfilePlugin plugin) {
        JavaDependency.JavaDependencyOptionalValueBuilder builder = JavaDependency.builder().groupId(plugin.dependency().groupId()).artifactId(plugin.dependency().artifactId());
        plugin.versionSlug().ifPresent(builder::versionSlug);
        return builder.build();
    }

    @Override
    public void handle(AddGradleConfiguration command) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_FREE_CONFIGURATION_BLOCKS_NEEDLE), "\n" + command.get());
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)), this.context);
    }

    @Override
    public void handle(AddGradleTasksTestInstruction command) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_TASKS_TEST_NEEDLE), this.indentation.times(1) + command.get());
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)), this.context);
    }
}

