/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven;

import io.fabric8.maven.Maven;
import io.fabric8.maven.XMLFormat;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.buildproperties.BuildProperty;
import tech.jhipster.lite.module.domain.buildproperties.PropertyKey;
import tech.jhipster.lite.module.domain.buildproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javabuild.MavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradleConfiguration;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradleTasksTestInstruction;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileActivation;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginConfiguration;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecution;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionGoal;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionId;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MalformedAdditionalInformationException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MavenType;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.maven.MissingMavenProfileException;
import tech.jhipster.lite.shared.enumeration.domain.Enums;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;

public class MavenCommandHandler
implements JavaDependenciesCommandHandler {
    private static final String COMMAND = "command";
    private final XMLFormat xmlFormat;
    private final Path pomPath;
    private final Model pomModel;

    public MavenCommandHandler(Indentation indentation, Path pomPath) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("pomPath", pomPath);
        this.xmlFormat = XMLFormat.builder((XMLFormat)XMLFormat.DEFAULT).indent(indentation.spaces()).build();
        this.pomPath = pomPath;
        this.pomModel = this.readModel(pomPath);
    }

    private Model readModel(Path pomPath) {
        try {
            return Maven.readModel((Path)pomPath);
        }
        catch (UncheckedIOException e) {
            throw GeneratorException.technicalError("Error reading pom: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(SetVersion command) {
        Assert.notNull(COMMAND, command);
        BuildProperty property = new BuildProperty(new PropertyKey(command.property()), new PropertyValue(command.dependencyVersion()));
        this.handle(new SetBuildProperty(property));
    }

    @Override
    public void handle(SetBuildProperty command) {
        Assert.notNull(COMMAND, command);
        ModelBase model = command.buildProfile().map(this::findProfile).map(ModelBase.class::cast).orElse((ModelBase)this.pomModel);
        model.addProperty(command.property().key().get(), command.property().value().get());
        this.writePom();
    }

    private Profile findProfile(BuildProfileId buildProfileId) {
        return this.pomModel.getProfiles().stream().filter(MavenCommandHandler.profileMatch(buildProfileId)).findFirst().orElseThrow(() -> new MissingMavenProfileException(buildProfileId));
    }

    private static Predicate<Profile> profileMatch(BuildProfileId buildProfileId) {
        return profile -> profile.getId().equals(buildProfileId.value());
    }

    @Override
    public void handle(AddJavaBuildProfile command) {
        Assert.notNull(COMMAND, command);
        List profiles = this.pomModel.getProfiles();
        if (profiles.stream().noneMatch(MavenCommandHandler.profileMatch(command.buildProfileId()))) {
            Profile profile = MavenCommandHandler.toMavenProfile(command);
            this.pomModel.addProfile(profile);
        }
        this.writePom();
    }

    private static Profile toMavenProfile(AddJavaBuildProfile command) {
        Profile profile = new Profile();
        profile.setId(command.buildProfileId().value());
        command.activation().ifPresent(activation -> profile.setActivation(MavenCommandHandler.toMavenActivation(activation)));
        return profile;
    }

    private static Activation toMavenActivation(BuildProfileActivation activation) {
        Activation mavenActivation = new Activation();
        activation.activeByDefault().ifPresent(arg_0 -> ((Activation)mavenActivation).setActiveByDefault(arg_0));
        return mavenActivation;
    }

    @Override
    public void handle(RemoveJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        DependencyManagement dependencyManagement = command.buildProfile().map(this::findProfile).map(ModelBase::getDependencyManagement).orElse(this.pomModel.getDependencyManagement());
        if (dependencyManagement != null) {
            this.removeDependencyFrom(command.dependency(), dependencyManagement.getDependencies()).stream().map(Dependency::getVersion).forEach(this::removeUnusedVersionProperty);
        }
    }

    @Override
    public void handle(RemoveDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        List dependencies = command.buildProfile().map(this::findProfile).map(ModelBase::getDependencies).orElse(this.pomModel.getDependencies());
        this.removeDependencyFrom(command.dependency(), dependencies).stream().map(Dependency::getVersion).forEach(this::removeUnusedVersionProperty);
    }

    private List<Dependency> removeDependencyFrom(DependencyId dependency, List<Dependency> dependencies) {
        List<Dependency> dependenciesToRemove = dependencies.stream().filter(this.matchesDependency(dependency)).toList();
        if (!dependenciesToRemove.isEmpty()) {
            dependencies.removeAll(dependenciesToRemove);
            this.writePom();
        }
        return dependenciesToRemove;
    }

    private Predicate<Dependency> matchesDependency(DependencyId dependency) {
        return mavenDependency -> {
            boolean sameGroupId = mavenDependency.getGroupId().equals(dependency.groupId().get());
            boolean sameArtifactId = mavenDependency.getArtifactId().equals(dependency.artifactId().get());
            return sameGroupId && sameArtifactId;
        };
    }

    private void removeUnusedVersionProperty(String version) {
        this.extractVersionPropertyKey(version).filter(this::versionPropertyUnused).ifPresent(propertyKey -> {
            this.pomModel.getProperties().remove(propertyKey);
            this.writePom();
        });
    }

    private Stream<Dependency> allDependencies() {
        return Stream.of(this.pomModel.getDependencies().stream(), this.pomModel.getProfiles().stream().flatMap(profile -> profile.getDependencies().stream()), this.dependenciesFrom(this.pomModel.getDependencyManagement()), this.pomModel.getProfiles().stream().flatMap(profile -> this.dependenciesFrom(profile.getDependencyManagement()))).flatMap(Function.identity());
    }

    private Stream<Dependency> dependenciesFrom(DependencyManagement dependencyManagement) {
        return dependencyManagement != null ? dependencyManagement.getDependencies().stream() : Stream.empty();
    }

    private Optional<String> extractVersionPropertyKey(String version) {
        return VersionSlug.of(version).map(VersionSlug::propertyName);
    }

    private boolean versionPropertyUnused(String versionPropertyKey) {
        return this.allDependencies().map(Dependency::getVersion).flatMap(version -> this.extractVersionPropertyKey((String)version).stream()).noneMatch(versionPropertyKey::equals);
    }

    @Override
    public void handle(AddMavenBuildExtension command) {
        Assert.notNull(COMMAND, command);
        this.projectBuild().addExtension(MavenCommandHandler.toMavenExtension(command.buildExtension()));
        this.writePom();
    }

    private Build projectBuild() {
        if (this.pomModel.getBuild() == null) {
            this.pomModel.setBuild(new Build());
        }
        return this.pomModel.getBuild();
    }

    private static Extension toMavenExtension(MavenBuildExtension mavenBuildExtension) {
        Extension extension = new Extension();
        extension.setArtifactId(mavenBuildExtension.artifactId().get());
        extension.setGroupId(mavenBuildExtension.groupId().get());
        mavenBuildExtension.versionSlug().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Extension)extension).setVersion(arg_0));
        return extension;
    }

    @Override
    public void handle(AddJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        DependencyManagement dependencyManagement = command.buildProfile().map(this::findProfile).map(this::dependencyManagement).orElse(this.dependencyManagement());
        this.addDependencyTo(command.dependency(), dependencyManagement.getDependencies());
    }

    private DependencyManagement dependencyManagement(Profile mavenProfile) {
        return Optional.ofNullable(mavenProfile.getDependencyManagement()).or(() -> Optional.of(new DependencyManagement())).map(dependencyManagement -> {
            mavenProfile.setDependencyManagement(dependencyManagement);
            return dependencyManagement;
        }).orElseThrow();
    }

    private DependencyManagement dependencyManagement() {
        if (this.pomModel.getDependencyManagement() == null) {
            this.pomModel.setDependencyManagement(new DependencyManagement());
        }
        return this.pomModel.getDependencyManagement();
    }

    @Override
    public void handle(AddDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        List dependencies = command.buildProfile().map(this::findProfile).map(ModelBase::getDependencies).orElse(this.pomModel.getDependencies());
        this.addDependencyTo(command.dependency(), dependencies);
    }

    private void addDependencyTo(JavaDependency dependency, List<Dependency> dependencies) {
        if (dependency.scope() == JavaDependencyScope.TEST) {
            dependencies.add(this.toMavenDependency(dependency));
        } else {
            Dependency mavenDependency = this.toMavenDependency(dependency);
            this.insertDependencyBeforeFirstTestDependency(mavenDependency, dependencies);
        }
        this.writePom();
    }

    private void insertDependencyBeforeFirstTestDependency(Dependency mavenDependency, List<Dependency> dependencies) {
        List<Dependency> nonTestDependencies = dependencies.stream().filter(dependency -> !MavenScope.TEST.key().equals(dependency.getScope())).toList();
        if (nonTestDependencies.isEmpty()) {
            dependencies.add(mavenDependency);
        } else {
            dependencies.add(dependencies.indexOf(nonTestDependencies.getLast()) + 1, mavenDependency);
        }
    }

    private Dependency toMavenDependency(JavaDependency javaDependency) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(javaDependency.id().groupId().get());
        mavenDependency.setArtifactId(javaDependency.id().artifactId().get());
        javaDependency.version().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Dependency)mavenDependency).setVersion(arg_0));
        javaDependency.classifier().map(JavaDependencyClassifier::get).ifPresent(arg_0 -> ((Dependency)mavenDependency).setClassifier(arg_0));
        javaDependency.type().map(type -> Enums.map(type, MavenType.class)).map(MavenType::key).ifPresent(arg_0 -> ((Dependency)mavenDependency).setType(arg_0));
        javaDependency.exclusions().stream().map(this.toMavenExclusion()).forEach(arg_0 -> ((Dependency)mavenDependency).addExclusion(arg_0));
        if (javaDependency.scope() != JavaDependencyScope.COMPILE) {
            mavenDependency.setScope(Enums.map(javaDependency.scope(), MavenScope.class).key());
        }
        if (javaDependency.optional()) {
            mavenDependency.setOptional(true);
        }
        return mavenDependency;
    }

    private Function<DependencyId, Exclusion> toMavenExclusion() {
        return dependencyId -> {
            Exclusion mavenExclusion = new Exclusion();
            mavenExclusion.setGroupId(dependencyId.groupId().get());
            mavenExclusion.setArtifactId(dependencyId.artifactId().get());
            return mavenExclusion;
        };
    }

    @Override
    public void handle(AddMavenPluginManagement command) {
        Assert.notNull(COMMAND, command);
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.dependenciesVersions().forEach(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        PluginManagement pluginManagement = command.buildProfile().map(this::findProfile).map(this::pluginManagement).orElse(this.pluginManagement());
        MavenCommandHandler.replaceOrAddPlugin(pluginManagement.getPlugins(), this.toMavenPlugin(command));
        this.writePom();
    }

    private PluginManagement pluginManagement(Profile mavenProfile) {
        if (this.profileBuild(mavenProfile).getPluginManagement() == null) {
            this.profileBuild(mavenProfile).setPluginManagement(new PluginManagement());
        }
        return this.profileBuild(mavenProfile).getPluginManagement();
    }

    private PluginManagement pluginManagement() {
        if (this.projectBuild().getPluginManagement() == null) {
            this.projectBuild().setPluginManagement(new PluginManagement());
        }
        return this.projectBuild().getPluginManagement();
    }

    @Override
    public void handle(AddDirectMavenPlugin command) {
        Assert.notNull(COMMAND, command);
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.dependenciesVersions().forEach(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        BuildBase build = command.buildProfile().map(this::findProfile).map(this::profileBuild).orElse((BuildBase)this.projectBuild());
        MavenCommandHandler.replaceOrAddPlugin(build.getPlugins(), this.toMavenPlugin(command));
        this.writePom();
    }

    private static void replaceOrAddPlugin(List<Plugin> plugins, Plugin newPlugin) {
        for (int i = 0; i < plugins.size(); ++i) {
            Plugin existingPlugin = plugins.get(i);
            if (!existingPlugin.getGroupId().equals(newPlugin.getGroupId()) || !existingPlugin.getArtifactId().equals(newPlugin.getArtifactId())) continue;
            plugins.set(i, newPlugin);
            return;
        }
        plugins.add(newPlugin);
    }

    private BuildBase profileBuild(Profile mavenProfile) {
        if (mavenProfile.getBuild() == null) {
            mavenProfile.setBuild((BuildBase)new Build());
        }
        return mavenProfile.getBuild();
    }

    @Override
    public void handle(AddGradlePlugin command) {
    }

    @Override
    public void handle(AddGradleConfiguration command) {
    }

    @Override
    public void handle(AddGradleTasksTestInstruction command) {
    }

    private Plugin toMavenPlugin(AddMavenPlugin command) {
        Plugin mavenPlugin = new Plugin();
        mavenPlugin.setArtifactId(command.dependencyId().artifactId().get());
        mavenPlugin.setGroupId(command.dependencyId().groupId().get());
        command.versionSlug().map(VersionSlug::mavenVariable).ifPresent(arg_0 -> ((Plugin)mavenPlugin).setVersion(arg_0));
        command.configuration().map(this.toMavenConfiguration()).ifPresent(arg_0 -> ((Plugin)mavenPlugin).setConfiguration(arg_0));
        command.executions().stream().map(this.toMavenExecution()).forEach(arg_0 -> ((Plugin)mavenPlugin).addExecution(arg_0));
        command.dependencies().stream().map(this::toMavenDependency).forEach(arg_0 -> ((Plugin)mavenPlugin).addDependency(arg_0));
        return mavenPlugin;
    }

    private Function<MavenPluginExecution, PluginExecution> toMavenExecution() {
        return execution -> {
            PluginExecution mavenExecution = new PluginExecution();
            execution.id().map(MavenPluginExecutionId::get).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setId(arg_0));
            execution.phase().map(MavenBuildPhase::mavenKey).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setPhase(arg_0));
            execution.goals().stream().map(MavenPluginExecutionGoal::get).forEach(arg_0 -> ((PluginExecution)mavenExecution).addGoal(arg_0));
            execution.configuration().map(this.toMavenConfiguration()).ifPresent(arg_0 -> ((PluginExecution)mavenExecution).setConfiguration(arg_0));
            return mavenExecution;
        };
    }

    private Function<MavenPluginConfiguration, Xpp3Dom> toMavenConfiguration() {
        return configuration -> {
            Xpp3Dom xpp3Dom;
            StringReader reader = new StringReader("<configuration>" + configuration.get() + "</configuration>");
            try {
                xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new MalformedAdditionalInformationException(e);
                }
            }
            ((Reader)reader).close();
            return xpp3Dom;
        };
    }

    private void writePom() {
        Maven.writeModel((Model)this.pomModel, (Path)this.pomPath, (XMLFormat)this.xmlFormat);
    }
}

