/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.statistic.domain;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.statistic.domain.AppliedModuleId;
import tech.jhipster.lite.statistic.domain.Module;
import tech.jhipster.lite.statistic.domain.ModuleProperties;
import tech.jhipster.lite.statistic.domain.ProjectPath;

public final class AppliedModule {
    private final AppliedModuleId id;
    private final ProjectPath path;
    private final Module module;
    private final Instant date;
    private final ModuleProperties properties;

    private AppliedModule(ModuleAppliedBuilder builder) {
        this.assertMandatoryFields(builder);
        this.id = builder.id;
        this.path = builder.path;
        this.module = builder.module;
        this.date = builder.date;
        this.properties = builder.properties;
    }

    private void assertMandatoryFields(ModuleAppliedBuilder builder) {
        Assert.notNull("id", builder.id);
        Assert.notNull("path", builder.path);
        Assert.notNull("module", builder.module);
        Assert.notNull("date", builder.date);
        Assert.notNull("properties", builder.properties);
    }

    public static ModuleAppliedIdBuilder builder() {
        return new ModuleAppliedBuilder();
    }

    public AppliedModuleId id() {
        return this.id;
    }

    public ProjectPath path() {
        return this.path;
    }

    public Module module() {
        return this.module;
    }

    public Instant date() {
        return this.date;
    }

    public ModuleProperties properties() {
        return this.properties;
    }

    private static final class ModuleAppliedBuilder
    implements ModuleAppliedIdBuilder,
    ModuleAppliedPathBuilder,
    ModuleAppliedModuleBuilder,
    ModuleAppliedApplicationDateBuilder,
    ModuleAppliedPropertiesBuilder {
        private AppliedModuleId id;
        private ProjectPath path;
        private Module module;
        private Instant date;
        private ModuleProperties properties;

        private ModuleAppliedBuilder() {
        }

        @Override
        public ModuleAppliedPathBuilder id(AppliedModuleId id) {
            this.id = id;
            return this;
        }

        @Override
        public ModuleAppliedModuleBuilder path(ProjectPath path) {
            this.path = path;
            return this;
        }

        @Override
        public ModuleAppliedApplicationDateBuilder module(Module module) {
            this.module = module;
            return this;
        }

        @Override
        public ModuleAppliedPropertiesBuilder date(Instant date) {
            this.date = date;
            return this;
        }

        @Override
        public AppliedModule properties(ModuleProperties properties) {
            this.properties = properties;
            return new AppliedModule(this);
        }
    }

    public static interface ModuleAppliedPropertiesBuilder {
        public AppliedModule properties(ModuleProperties var1);

        default public AppliedModule properties(Map<String, Object> properties) {
            return this.properties(new ModuleProperties(properties));
        }
    }

    public static interface ModuleAppliedApplicationDateBuilder {
        public ModuleAppliedPropertiesBuilder date(Instant var1);
    }

    public static interface ModuleAppliedModuleBuilder {
        public ModuleAppliedApplicationDateBuilder module(Module var1);

        default public ModuleAppliedApplicationDateBuilder module(String module) {
            return this.module(new Module(module));
        }
    }

    public static interface ModuleAppliedPathBuilder {
        public ModuleAppliedModuleBuilder path(ProjectPath var1);

        default public ModuleAppliedModuleBuilder path(String path) {
            return this.path(new ProjectPath(path));
        }
    }

    public static interface ModuleAppliedIdBuilder {
        public ModuleAppliedPathBuilder id(AppliedModuleId var1);

        default public ModuleAppliedPathBuilder id(UUID id) {
            return this.id(new AppliedModuleId(id));
        }
    }
}

