/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.ci.sonarqube.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.ci.sonarqube.application.SonarQubeApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class SonarQubeModuleConfiguration {
    SonarQubeModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource sonarqubeBackendModule(SonarQubeApplicationService sonarQube) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SONARQUBE_JAVA_BACKEND).propertiesDefinition(this.propertiesDefinition()).apiDoc("SonarQube", "Add Sonar configuration for Java Backend to inspect code quality").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.SONARQUBE).addDependency(JHLiteFeatureSlug.JAVA_BUILD_TOOL).addDependency(JHLiteFeatureSlug.CODE_COVERAGE_JAVA).build()).tags("server", "sonar", "sonarqube").factory(sonarQube::buildBackendModule);
    }

    @Bean
    JHipsterModuleResource sonarqubeBackendFrontendModule(SonarQubeApplicationService sonarQube) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SONARQUBE_JAVA_BACKEND_AND_FRONTEND).propertiesDefinition(this.propertiesDefinition()).apiDoc("SonarQube", "Add Sonar configuration for Java Backend and Frontend to inspect code quality").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.SONARQUBE).addDependency(JHLiteFeatureSlug.JAVA_BUILD_TOOL).addDependency(JHLiteFeatureSlug.CODE_COVERAGE_JAVA).build()).tags("server", "frontend", "sonar", "sonarqube").factory(sonarQube::buildBackendFrontendModule);
    }

    @Bean
    JHipsterModuleResource sonarqubeTypescriptModule(SonarQubeApplicationService sonarTypescript) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SONARQUBE_TYPESCRIPT).withoutProperties().apiDoc("Typescript", "Add Sonar to project").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.SONARQUBE).addDependency(JHLiteModuleSlug.TYPESCRIPT).build()).tags("typescript").factory(sonarTypescript::buildTypescriptModule);
    }

    private JHipsterModulePropertiesDefinition propertiesDefinition() {
        return JHipsterModulePropertiesDefinition.builder().addProjectName().addProjectBaseName().addIndentation().build();
    }
}

