/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.prettier.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.nodejs.JHLiteNodePackagesVersionSource;
import tech.jhipster.lite.module.domain.nodejs.NodeLazyPackagesInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class PrettierModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("prettier");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(".");
    private final NodeLazyPackagesInstaller nodeLazyPackagesInstaller;

    public PrettierModuleFactory(NodeLazyPackagesInstaller nodeLazyPackagesInstaller) {
        this.nodeLazyPackagesInstaller = nodeLazyPackagesInstaller;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).put("endOfLine", this.endOfLine(properties)).and().files().batch(SOURCE, DESTINATION).addFile(".prettierignore").addTemplate(".prettierrc").and().and().packageJson().addDevDependency(JHipsterModule.packageName("@prettier/plugin-xml"), JHLiteNodePackagesVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier"), JHLiteNodePackagesVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-gherkin"), JHLiteNodePackagesVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-java"), JHLiteNodePackagesVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-organize-imports"), JHLiteNodePackagesVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-packagejson"), JHLiteNodePackagesVersionSource.COMMON).addScript(JHipsterModule.scriptKey("prettier:check"), JHipsterModule.scriptCommand("prettier --check .")).addScript(JHipsterModule.scriptKey("prettier:format"), JHipsterModule.scriptCommand("prettier --write .")).and().postActions().add(context -> this.nodeLazyPackagesInstaller.runInstallIn(context.projectFolder(), properties.nodePackageManager())).and().preCommitActions(JHipsterModule.stagedFilesFilter("*.{md,json*,yml,html,css,scss,java,xml,feature}"), JHipsterModule.preCommitCommands("['prettier --write']")).build();
    }

    private String endOfLine(JHipsterModuleProperties properties) {
        return properties.getOrDefaultString("endOfLine", "lf");
    }
}

