/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.checkstyle.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CheckstyleModuleFactory {
    private static final JHipsterSource TEMPLATES_SOURCE = JHipsterModule.from("server/javatool/checkstyle/main");
    private static final String CHECKSTYLE = "checkstyle";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(this.checkstyleMavenPlugin()).and().gradlePlugins().plugin(this.checkstyleGradlePlugin()).and().files().add(TEMPLATES_SOURCE.template("checkstyle.xml"), JHipsterModule.to("checkstyle.xml")).and().build();
    }

    private MavenPlugin checkstyleMavenPlugin() {
        return JHipsterModule.mavenPlugin().groupId("org.apache.maven.plugins").artifactId("maven-checkstyle-plugin").versionSlug("maven-checkstyle-plugin").configuration("<configLocation>checkstyle.xml</configLocation>\n<consoleOutput>true</consoleOutput>\n<failsOnError>true</failsOnError>\n<includeTestSourceDirectory>true</includeTestSourceDirectory>\n<sourceDirectories>\n  <!-- only include main source directory, not generated sources directories -->\n  <sourceDirectory>${project.build.sourceDirectory}</sourceDirectory>\n</sourceDirectories>\n<testSourceDirectories>\n  <!-- only include main test source directory, not generated test sources directories -->\n  <testSourceDirectory>${project.build.testSourceDirectory}</testSourceDirectory>\n</testSourceDirectories>\n").addDependency(this.checkstyleDependency()).addExecution(JHipsterModule.pluginExecution().goals("check").id("validate").phase(MavenBuildPhase.VALIDATE)).build();
    }

    private JavaDependency checkstyleDependency() {
        return JHipsterModule.javaDependency().groupId("com.puppycrawl.tools").artifactId(CHECKSTYLE).versionSlug(CHECKSTYLE).build();
    }

    private GradleMainBuildPlugin checkstyleGradlePlugin() {
        VersionSlug toolVersionSlug = new VersionSlug(CHECKSTYLE);
        return JHipsterModule.gradleCorePlugin().id(CHECKSTYLE).toolVersionSlug(toolVersionSlug).configuration("checkstyle {\n  configFile = rootProject.file(\"checkstyle.xml\")\n  toolVersion = libs.versions.%s.get()\n}\n".formatted(toolVersionSlug.slug())).build();
    }
}

