/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.frontendmaven.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecution;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginExecutionGoal;
import tech.jhipster.lite.module.domain.nodejs.NodePackageManager;

final class MavenFrontendPluginExecutions {
    private static final MavenPluginExecutionGoal NPM = new MavenPluginExecutionGoal("npm");
    private static final MavenPluginExecutionGoal COREPACK = new MavenPluginExecutionGoal("corepack");

    private MavenFrontendPluginExecutions() {
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder installNode(NodePackageManager nodePackageManager) {
        return switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> JHipsterModule.pluginExecution().goals("install-node-and-npm").id("install-node-and-npm").configuration("<nodeVersion>${node.version}</nodeVersion>\n<npmVersion>${npm.version}</npmVersion>\n");
            case NodePackageManager.PNPM -> JHipsterModule.pluginExecution().goals("install-node-and-corepack").id("install-node-and-corepack").configuration("<nodeVersion>${node.version}</nodeVersion>\n");
        };
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder installPackages(NodePackageManager nodePackageManager) {
        return switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> JHipsterModule.pluginExecution().goals("npm").id("npm install");
            case NodePackageManager.PNPM -> JHipsterModule.pluginExecution().goals(COREPACK).id("pnpm install").configuration("<arguments>pnpm install</arguments>");
        };
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder buildFront(NodePackageManager nodePackageManager) {
        return switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> JHipsterModule.pluginExecution().goals(NPM).id("build front").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<arguments>run build</arguments>\n<environmentVariables>\n  <APP_VERSION>${project.version}</APP_VERSION>\n</environmentVariables>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n");
            case NodePackageManager.PNPM -> JHipsterModule.pluginExecution().goals(COREPACK).id("build front").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<arguments>pnpm build</arguments>\n<environmentVariables>\n  <APP_VERSION>${project.version}</APP_VERSION>\n</environmentVariables>\n");
        };
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder testFront(NodePackageManager nodePackageManager) {
        return MavenFrontendPluginExecutions.runNodeScriptDuringTestPhase("test:coverage", nodePackageManager, "front test");
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder componentTest(NodePackageManager nodePackageManager) {
        return MavenFrontendPluginExecutions.runNodeScriptDuringTestPhase("test:component:headless", nodePackageManager, "front component test");
    }

    static MavenPluginExecution.MavenPluginExecutionOptionalBuilder testCoverageCheck(NodePackageManager nodePackageManager) {
        return MavenFrontendPluginExecutions.runNodeScriptDuringTestPhase("test:coverage:check", nodePackageManager, "front verify coverage");
    }

    private static MavenPluginExecution.MavenPluginExecutionOptionalBuilder runNodeScriptDuringTestPhase(String nodeScriptName, NodePackageManager nodePackageManager, String pluginExecutionId) {
        return switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> JHipsterModule.pluginExecution().goals(NPM).id(pluginExecutionId).phase(MavenBuildPhase.TEST).configuration("<arguments>run %s</arguments>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n".formatted(nodeScriptName));
            case NodePackageManager.PNPM -> JHipsterModule.pluginExecution().goals(COREPACK).id(pluginExecutionId).phase(MavenBuildPhase.TEST).configuration("<arguments>pnpm %s</arguments>".formatted(nodeScriptName));
        };
    }
}

