/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.cache.ehcache.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.cache.ehcache.application.EhcacheApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class EhcacheModuleConfiguration {
    private static final String SPRING_BOOT_TAG = "spring-boot";
    private static final String CACHE_TAG = "cache";

    EhcacheModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource javaEHCacheModule(EhcacheApplicationService ehCache) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.EHCACHE_JAVA_CONFIG).propertiesDefinition(this.properties()).apiDoc("Spring Boot - Cache", "Add Ehcache with Java configuration").organization(this.organization()).tags("server", "spring", SPRING_BOOT_TAG, CACHE_TAG).factory(ehCache::buildJavaConfigurationModule);
    }

    @Bean
    JHipsterModuleResource xmlEHCacheModule(EhcacheApplicationService ehCache) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.EHCACHE_XML_CONFIG).propertiesDefinition(this.properties()).apiDoc("Spring Boot - Cache", "Add Ehcache with XML configuration").organization(this.organization()).tags("server", "spring", SPRING_BOOT_TAG, CACHE_TAG).factory(ehCache::buildXmlConfigurationModule);
    }

    private JHipsterModulePropertiesDefinition properties() {
        return JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addSpringConfigurationFormat().build();
    }

    private JHipsterModuleOrganization organization() {
        return JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JCACHE).addDependency(JHLiteModuleSlug.SPRING_BOOT_CACHE).build();
    }
}

