/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.datasource.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImageName;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;

public final class DatasourceProperties {
    private final String id;
    private final String databaseName;
    private final JavaDependency driverDependency;
    private final String driverClassName;
    private final DockerImageName dockerImageName;
    private final ArtifactId testContainerArtifactId;

    private DatasourceProperties(DatasourcePropertiesBuilder builder) {
        this.id = builder.id;
        this.databaseName = builder.databaseName;
        this.driverDependency = builder.driverDependency;
        this.driverClassName = builder.driverClassName;
        this.dockerImageName = builder.dockerImageName;
        this.testContainerArtifactId = builder.testContainerArtifactId;
    }

    public static DatasourcePropertiesIdBuilder builder() {
        return new DatasourcePropertiesBuilder();
    }

    public String id() {
        return this.id;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public JavaDependency driverDependency() {
        return this.driverDependency;
    }

    public String driverClassName() {
        return this.driverClassName;
    }

    public DockerImageName dockerImageName() {
        return this.dockerImageName;
    }

    public JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId(this.testContainerArtifactId).dependencySlug("%s-%s".formatted("testcontainers", this.testContainerArtifactId)).versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }

    private static final class DatasourcePropertiesBuilder
    implements DatasourcePropertiesIdBuilder,
    DatasourcePropertiesDatabaseNameBuilder,
    DatasourcePropertiesDriverDependencyBuilder,
    DatasourcePropertiesDriverClassNameBuilder,
    DatasourcePropertiesDockerImageNameBuilder,
    DatasourcePropertiesTestContainerArtifactIdBuilder {
        private String id;
        private String databaseName;
        private JavaDependency driverDependency;
        private String driverClassName;
        private DockerImageName dockerImageName;
        private ArtifactId testContainerArtifactId;

        private DatasourcePropertiesBuilder() {
        }

        @Override
        public DatasourcePropertiesDatabaseNameBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public DatasourcePropertiesDriverDependencyBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public DatasourcePropertiesDriverClassNameBuilder driverDependency(JavaDependency driverDependency) {
            this.driverDependency = driverDependency;
            return this;
        }

        @Override
        public DatasourcePropertiesDockerImageNameBuilder driverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        @Override
        public DatasourcePropertiesTestContainerArtifactIdBuilder dockerImageName(DockerImageName dockerImageName) {
            this.dockerImageName = dockerImageName;
            return this;
        }

        @Override
        public DatasourceProperties testContainerArtifactId(ArtifactId testContainerArtifactId) {
            this.testContainerArtifactId = testContainerArtifactId;
            return new DatasourceProperties(this);
        }
    }

    public static sealed interface DatasourcePropertiesTestContainerArtifactIdBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourceProperties testContainerArtifactId(ArtifactId var1);
    }

    public static sealed interface DatasourcePropertiesDockerImageNameBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourcePropertiesTestContainerArtifactIdBuilder dockerImageName(DockerImageName var1);
    }

    public static sealed interface DatasourcePropertiesDriverClassNameBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourcePropertiesDockerImageNameBuilder driverClassName(String var1);
    }

    public static sealed interface DatasourcePropertiesDriverDependencyBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourcePropertiesDriverClassNameBuilder driverDependency(JavaDependency var1);
    }

    public static sealed interface DatasourcePropertiesDatabaseNameBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourcePropertiesDriverDependencyBuilder databaseName(String var1);
    }

    public static sealed interface DatasourcePropertiesIdBuilder
    permits DatasourcePropertiesBuilder {
        public DatasourcePropertiesDatabaseNameBuilder id(String var1);
    }
}

