/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.nio.charset.StandardCharsets;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.file.TemplateRenderer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterFileContent {
    private final JHipsterSource source;

    public JHipsterFileContent(JHipsterSource source) {
        Assert.notNull("source", source);
        this.source = source;
    }

    public byte[] read(ProjectFiles files, JHipsterModuleContext context, TemplateRenderer templateRenderer) {
        Assert.notNull("files", files);
        Assert.notNull("context", context);
        Assert.notNull("templateRenderer", templateRenderer);
        if (this.source.isNotTemplate()) {
            return files.readBytes(this.source.get().toString());
        }
        String rawContent = files.readString(this.source.get().toString());
        return templateRenderer.render(rawContent, context).getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.source.toString();
    }
}

