/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public final class DependencyId {
    private final GroupId groupId;
    private final ArtifactId artifactId;
    private final Optional<JavaDependencyClassifier> classifier;
    private final Optional<JavaDependencyType> type;

    private DependencyId(DependencyIdBuilder builder) {
        Assert.notNull("groupId", builder.groupId);
        Assert.notNull("artifactId", builder.artifactId);
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.classifier = Optional.ofNullable(builder.classifier);
        this.type = Optional.ofNullable(builder.type);
    }

    public static DependencyIdGroupIdBuilder builder() {
        return new DependencyIdBuilder();
    }

    public static DependencyId of(GroupId groupId, ArtifactId artifactId) {
        return DependencyId.builder().groupId(groupId).artifactId(artifactId).build();
    }

    public GroupId groupId() {
        return this.groupId;
    }

    public ArtifactId artifactId() {
        return this.artifactId;
    }

    public Optional<JavaDependencyClassifier> classifier() {
        return this.classifier;
    }

    public Optional<JavaDependencyType> type() {
        return this.type;
    }

    @ExcludeFromGeneratedCodeCoverage
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.artifactId).append(this.classifier).append((Object)this.groupId).append(this.type).hashCode();
    }

    @ExcludeFromGeneratedCodeCoverage
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyId other = (DependencyId)obj;
        return new EqualsBuilder().append((Object)this.artifactId, (Object)other.artifactId).append(this.classifier, other.classifier).append((Object)this.groupId, (Object)other.groupId).append(this.type, other.type).isEquals();
    }

    @ExcludeFromGeneratedCodeCoverage
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("groupId", (Object)this.groupId).append("artifactId", (Object)this.artifactId).append("classifier", (Object)this.classifier.map(JavaDependencyClassifier::toString).orElse("")).append("type", (Object)this.type.map(Enum::toString).orElse(""));
        return builder.toString();
    }

    private static final class DependencyIdBuilder
    implements DependencyIdGroupIdBuilder,
    DependencyIdArtifactIdBuilder,
    DependencyIdOptionalFieldsBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private JavaDependencyClassifier classifier;
        private JavaDependencyType type;

        private DependencyIdBuilder() {
        }

        @Override
        public DependencyIdArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public DependencyIdOptionalFieldsBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public DependencyIdOptionalFieldsBuilder classifier(JavaDependencyClassifier classifier) {
            this.classifier = classifier;
            return this;
        }

        @Override
        public DependencyIdOptionalFieldsBuilder type(JavaDependencyType type) {
            this.type = type;
            return this;
        }

        @Override
        public DependencyId build() {
            return new DependencyId(this);
        }
    }

    public static interface DependencyIdGroupIdBuilder {
        public DependencyIdArtifactIdBuilder groupId(GroupId var1);
    }

    public static interface DependencyIdArtifactIdBuilder {
        public DependencyIdOptionalFieldsBuilder artifactId(ArtifactId var1);
    }

    public static interface DependencyIdOptionalFieldsBuilder {
        public DependencyIdOptionalFieldsBuilder classifier(JavaDependencyClassifier var1);

        public DependencyIdOptionalFieldsBuilder type(JavaDependencyType var1);

        public DependencyId build();
    }
}

