/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.Optional;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencies;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesVersions;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class ProjectJavaDependencies {
    public static final ProjectJavaDependencies EMPTY = ProjectJavaDependencies.builder().versions(null).dependenciesManagements(null).dependencies(null);
    private final ProjectJavaDependenciesVersions versions;
    private final JavaDependencies dependenciesManagement;
    private final JavaDependencies dependencies;

    private ProjectJavaDependencies(ProjectJavaDependenciesBuilder builder) {
        this.versions = this.buildVersions(builder.versions);
        this.dependenciesManagement = this.buildDependencies(builder.dependenciesManagement);
        this.dependencies = this.buildDependencies(builder.dependencies);
    }

    private ProjectJavaDependenciesVersions buildVersions(ProjectJavaDependenciesVersions versions) {
        if (versions == null) {
            return ProjectJavaDependenciesVersions.EMPTY;
        }
        return versions;
    }

    private JavaDependencies buildDependencies(JavaDependencies dependencies) {
        if (dependencies == null) {
            return JavaDependencies.EMPTY;
        }
        return dependencies;
    }

    public static ProjectJavaDependenciesVersionsBuilder builder() {
        return new ProjectJavaDependenciesBuilder();
    }

    public Optional<JavaDependencyVersion> version(VersionSlug slug) {
        return this.versions.get(slug);
    }

    public Optional<JavaDependency> dependency(DependencyId id) {
        return this.dependencies.get(id);
    }

    public Optional<JavaDependency> dependencyManagement(DependencyId id) {
        return this.dependenciesManagement.get(id);
    }

    public ProjectJavaDependenciesVersions versions() {
        return this.versions;
    }

    public JavaDependencies dependenciesManagement() {
        return this.dependenciesManagement;
    }

    public JavaDependencies dependencies() {
        return this.dependencies;
    }

    public ProjectJavaDependencies merge(ProjectJavaDependencies other) {
        Assert.notNull("other", other);
        return ProjectJavaDependencies.builder().versions(this.versions.merge(other.versions())).dependenciesManagements(this.dependenciesManagement.merge(other.dependenciesManagement)).dependencies(this.dependencies.merge(other.dependencies));
    }

    private static final class ProjectJavaDependenciesBuilder
    implements ProjectJavaDependenciesVersionsBuilder,
    ProjectJavaDependenciesDependenciesManagementBuilder,
    ProjectJavaDependenciesDependenciesBuilder {
        private ProjectJavaDependenciesVersions versions;
        private JavaDependencies dependenciesManagement;
        private JavaDependencies dependencies;

        private ProjectJavaDependenciesBuilder() {
        }

        @Override
        public ProjectJavaDependenciesDependenciesManagementBuilder versions(ProjectJavaDependenciesVersions versions) {
            this.versions = versions;
            return this;
        }

        @Override
        public ProjectJavaDependenciesDependenciesBuilder dependenciesManagements(JavaDependencies dependenciesManagement) {
            this.dependenciesManagement = dependenciesManagement;
            return this;
        }

        @Override
        public ProjectJavaDependencies dependencies(JavaDependencies dependencies) {
            this.dependencies = dependencies;
            return new ProjectJavaDependencies(this);
        }
    }

    public static interface ProjectJavaDependenciesVersionsBuilder {
        public ProjectJavaDependenciesDependenciesManagementBuilder versions(ProjectJavaDependenciesVersions var1);
    }

    public static interface ProjectJavaDependenciesDependenciesManagementBuilder {
        public ProjectJavaDependenciesDependenciesBuilder dependenciesManagements(JavaDependencies var1);
    }

    public static interface ProjectJavaDependenciesDependenciesBuilder {
        public ProjectJavaDependencies dependencies(JavaDependencies var1);
    }
}

