/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.nodejs;

import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.nodejs.NodePackageName;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public enum NodePackageManager {
    NPM("npm", "npm", new NodePackageName("npm"), "package-lock.json"),
    PNPM("pnpm", "pnpm", new NodePackageName("pnpm"), "pnpm-lock.yaml");

    private final String command;
    private final String propertyKey;
    private final NodePackageName packageName;
    private final String packageLockFile;

    private NodePackageManager(String command, String propertyKey, NodePackageName packageName, String packageLockFile) {
        Assert.notNull("command", command);
        Assert.notNull("propertyKey", propertyKey);
        Assert.notNull("packageName", packageName);
        Assert.notNull("packageLockFile", packageLockFile);
        this.command = command;
        this.propertyKey = propertyKey;
        this.packageName = packageName;
        this.packageLockFile = packageLockFile;
    }

    public static NodePackageManager fromPropertyKey(String input) {
        return Stream.of(NodePackageManager.values()).filter(configFormat -> configFormat.propertyKey.equals(input)).findFirst().orElseThrow();
    }

    public String packageLockFile() {
        return this.packageLockFile;
    }

    public String propertyKey() {
        return this.propertyKey;
    }

    public String command() {
        return this.command;
    }

    public String windowsCommand() {
        return "%s.cmd".formatted(this.command);
    }

    @ExcludeFromGeneratedCodeCoverage
    public String toString() {
        return this.command();
    }

    public NodePackageName packageName() {
        return this.packageName;
    }
}

