/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.packagejson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.nodejs.NodePackagesVersionSourceFactory;
import tech.jhipster.lite.module.domain.packagejson.NodeModuleFormat;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependencies;
import tech.jhipster.lite.module.domain.packagejson.PackageJsonDependency;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.PackageNames;
import tech.jhipster.lite.module.domain.packagejson.Script;
import tech.jhipster.lite.module.domain.packagejson.ScriptCommand;
import tech.jhipster.lite.module.domain.packagejson.ScriptKey;
import tech.jhipster.lite.module.domain.packagejson.Scripts;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModulePackageJson {
    private final Scripts scripts;
    private final PackageJsonDependencies dependencies;
    private final PackageNames dependenciesToRemove;
    private final PackageJsonDependencies devDependencies;
    private final PackageNames devDependenciesToRemove;
    private final Optional<NodeModuleFormat> nodeModuleFormat;

    private JHipsterModulePackageJson(JHipsterModulePackageJsonBuilder builder) {
        this.scripts = new Scripts(builder.scripts);
        this.dependencies = new PackageJsonDependencies(builder.dependencies);
        this.dependenciesToRemove = new PackageNames(builder.dependenciesToRemove);
        this.devDependencies = new PackageJsonDependencies(builder.devDependencies);
        this.devDependenciesToRemove = new PackageNames(builder.devDependenciesToRemove);
        this.nodeModuleFormat = Optional.ofNullable(builder.nodeModuleFormat);
    }

    public static JHipsterModulePackageJsonBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModulePackageJsonBuilder(module);
    }

    public boolean isEmpty() {
        return this.nodeModuleFormat.isEmpty() && this.scripts.isEmpty() && this.dependencies.isEmpty() && this.devDependencies.isEmpty() && this.dependenciesToRemove.isEmpty() && this.devDependenciesToRemove.isEmpty();
    }

    public Scripts scripts() {
        return this.scripts;
    }

    public PackageJsonDependencies devDependencies() {
        return this.devDependencies;
    }

    public PackageJsonDependencies dependencies() {
        return this.dependencies;
    }

    public PackageNames devDependenciesToRemove() {
        return this.devDependenciesToRemove;
    }

    public PackageNames dependenciesToRemove() {
        return this.dependenciesToRemove;
    }

    public Optional<NodeModuleFormat> nodeModuleFormat() {
        return this.nodeModuleFormat;
    }

    public static final class JHipsterModulePackageJsonBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<Script> scripts = new ArrayList<Script>();
        private final Collection<PackageJsonDependency> dependencies = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageJsonDependency> devDependencies = new ArrayList<PackageJsonDependency>();
        private final Collection<PackageName> dependenciesToRemove = new ArrayList<PackageName>();
        private final Collection<PackageName> devDependenciesToRemove = new ArrayList<PackageName>();
        private NodeModuleFormat nodeModuleFormat;

        private JHipsterModulePackageJsonBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModulePackageJsonBuilder addScript(ScriptKey key, ScriptCommand command) {
            this.scripts.add(new Script(key, command));
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDependency(PackageName packageName, NodePackagesVersionSourceFactory versionSource) {
            this.dependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource.build()).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDependency(PackageName packageName, NodePackagesVersionSourceFactory versionSource, PackageName versionPackageName) {
            this.dependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource.build()).versionPackageName(versionPackageName).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder removeDependency(PackageName packageName) {
            this.dependenciesToRemove.add(packageName);
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDevDependency(PackageName packageName, NodePackagesVersionSourceFactory versionSource) {
            this.devDependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource.build()).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder addDevDependency(PackageName packageName, NodePackagesVersionSourceFactory versionSource, PackageName versionPackageName) {
            this.devDependencies.add(PackageJsonDependency.builder().packageName(packageName).versionSource(versionSource.build()).versionPackageName(versionPackageName).build());
            return this;
        }

        public JHipsterModulePackageJsonBuilder removeDevDependency(PackageName packageName) {
            this.devDependenciesToRemove.add(packageName);
            return this;
        }

        public JHipsterModulePackageJsonBuilder type(NodeModuleFormat moduleFormat) {
            this.nodeModuleFormat = moduleFormat;
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModulePackageJson build() {
            return new JHipsterModulePackageJson(this);
        }
    }
}

