/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.startupcommand;

import java.util.ArrayList;
import java.util.Collection;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.startupcommand.DockerComposeFile;
import tech.jhipster.lite.module.domain.startupcommand.DockerComposeStartupCommandLine;
import tech.jhipster.lite.module.domain.startupcommand.GradleStartupCommandLine;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommand;
import tech.jhipster.lite.module.domain.startupcommand.JHipsterStartupCommands;
import tech.jhipster.lite.module.domain.startupcommand.MavenStartupCommandLine;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleStartupCommands {
    private final JHipsterStartupCommands commands;

    private JHipsterModuleStartupCommands(JHipsterModuleStartupCommandsBuilder builder) {
        this.commands = new JHipsterStartupCommands(builder.commands);
    }

    public static JHipsterModuleStartupCommandsBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleStartupCommandsBuilder(module);
    }

    public JHipsterStartupCommands commands() {
        return this.commands;
    }

    public static final class JHipsterModuleStartupCommandsBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<JHipsterStartupCommand> commands = new ArrayList<JHipsterStartupCommand>();

        private JHipsterModuleStartupCommandsBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleStartupCommandsBuilder dockerCompose(DockerComposeFile dockerComposeFile) {
            this.commands.add(new DockerComposeStartupCommandLine(dockerComposeFile));
            return this;
        }

        public JHipsterModuleStartupCommandsBuilder dockerCompose(String dockerComposeFile) {
            return this.dockerCompose(new DockerComposeFile(dockerComposeFile));
        }

        public JHipsterModuleStartupCommandsBuilder maven(String commandLineParameters) {
            this.commands.add(new MavenStartupCommandLine(commandLineParameters));
            return this;
        }

        public JHipsterModuleStartupCommandsBuilder gradle(String commandLineParameters) {
            this.commands.add(new GradleStartupCommandLine(commandLineParameters));
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleStartupCommands build() {
            return new JHipsterModuleStartupCommands(this);
        }
    }
}

