/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.primary;

import io.swagger.v3.oas.annotations.media.Schema;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyDefaultValue;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyDescription;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyType;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertyDefinition;

@Schema(name="JHipsterModulePropertyDefinition", description="Definition for a given property")
final class RestJHipsterModulePropertyDefinition {
    private final JHipsterPropertyType type;
    private final boolean mandatory;
    private final String key;
    private final String description;
    private final String defaultValue;
    private final int order;

    private RestJHipsterModulePropertyDefinition(RestJHipsterModulePropertyDefinitionBuilder builder) {
        this.type = builder.type;
        this.mandatory = builder.mandatory;
        this.key = builder.key;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.order = builder.order;
    }

    static RestJHipsterModulePropertyDefinition from(JHipsterModulePropertyDefinition propertyDefinition) {
        return new RestJHipsterModulePropertyDefinitionBuilder().type(propertyDefinition.type()).mandatory(propertyDefinition.isMandatory()).key(propertyDefinition.key().get()).description(propertyDefinition.description().map(JHipsterPropertyDescription::get).orElse(null)).defaultValue(propertyDefinition.defaultValue().map(JHipsterPropertyDefaultValue::get).orElse(null)).order(propertyDefinition.order()).build();
    }

    @Schema(description="Type of this property", requiredMode=Schema.RequiredMode.REQUIRED)
    public JHipsterPropertyType getType() {
        return this.type;
    }

    @Schema(description="True if this property is mandatory, false otherwise", requiredMode=Schema.RequiredMode.REQUIRED)
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Schema(description="Key of this property", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getKey() {
        return this.key;
    }

    @Schema(description="Full text description of this property")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="Default value for this property")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Schema(description="Order (sort in natural int sorting) for this property", requiredMode=Schema.RequiredMode.REQUIRED)
    public int getOrder() {
        return this.order;
    }

    private static final class RestJHipsterModulePropertyDefinitionBuilder {
        private JHipsterPropertyType type;
        private boolean mandatory;
        private String key;
        private String description;
        private String defaultValue;
        private int order;

        private RestJHipsterModulePropertyDefinitionBuilder() {
        }

        public RestJHipsterModulePropertyDefinitionBuilder type(JHipsterPropertyType type) {
            this.type = type;
            return this;
        }

        public RestJHipsterModulePropertyDefinitionBuilder mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public RestJHipsterModulePropertyDefinitionBuilder key(String key) {
            this.key = key;
            return this;
        }

        public RestJHipsterModulePropertyDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public RestJHipsterModulePropertyDefinitionBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public RestJHipsterModulePropertyDefinitionBuilder order(int order) {
            this.order = order;
            return this;
        }

        public RestJHipsterModulePropertyDefinition build() {
            return new RestJHipsterModulePropertyDefinition(this);
        }
    }
}

