/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import tech.jhipster.lite.module.domain.nodejs.NodePackageManager;
import tech.jhipster.lite.project.infrastructure.secondary.NativeHints;
import tech.jhipster.lite.project.infrastructure.secondary.NpmProjectFormatter;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectFormatter;
import tech.jhipster.lite.project.infrastructure.secondary.TraceProjectFormatter;
import tech.jhipster.lite.shared.npmdetector.infrastructure.secondary.NodePackageManagerInstallationReader;
import tech.jhipster.lite.shared.npmdetector.infrastructure.secondary.NodePackageManagerInstallationType;

@Configuration
@ImportRuntimeHints(value={NativeHints.class})
class ProjectFormatterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ProjectFormatterConfiguration.class);

    ProjectFormatterConfiguration() {
    }

    @Bean
    public ProjectFormatter projectFormatter(NodePackageManagerInstallationReader packageManagerInstallationReader) {
        return switch (packageManagerInstallationReader.get(NodePackageManager.NPM)) {
            default -> throw new MatchException(null, null);
            case NodePackageManagerInstallationType.UNIX -> this.unixFormatter();
            case NodePackageManagerInstallationType.WINDOWS -> this.windowsFormatter();
            case NodePackageManagerInstallationType.NONE -> this.traceFormatter();
        };
    }

    private NpmProjectFormatter unixFormatter() {
        log.info("Using unix formatter");
        return new NpmProjectFormatter("npm");
    }

    private NpmProjectFormatter windowsFormatter() {
        log.info("Using windows formatter");
        return new NpmProjectFormatter("npm.cmd");
    }

    private TraceProjectFormatter traceFormatter() {
        log.info("Using trace formatter");
        return new TraceProjectFormatter();
    }
}

