/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.domain;

import java.util.Map;
import tech.jhipster.lite.shared.error.domain.AssertionErrorType;
import tech.jhipster.lite.shared.error.domain.AssertionException;

public final class StringTooShortException
extends AssertionException {
    private final String minLength;
    private final String currentLength;

    private StringTooShortException(StringTooShortExceptionBuilder builder) {
        super(builder.field, builder.message());
        this.minLength = String.valueOf(builder.minLength);
        this.currentLength = String.valueOf(builder.value.length());
    }

    public static StringTooShortExceptionBuilder builder() {
        return new StringTooShortExceptionBuilder();
    }

    @Override
    public AssertionErrorType type() {
        return AssertionErrorType.STRING_TOO_SHORT;
    }

    @Override
    public Map<String, String> parameters() {
        return Map.of("minLength", this.minLength, "currentLength", this.currentLength);
    }

    public static final class StringTooShortExceptionBuilder {
        private String value;
        private int minLength;
        private String field;

        private StringTooShortExceptionBuilder() {
        }

        StringTooShortExceptionBuilder field(String field) {
            this.field = field;
            return this;
        }

        StringTooShortExceptionBuilder value(String value) {
            this.value = value;
            return this;
        }

        StringTooShortExceptionBuilder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        private String message() {
            return "The value in field \"" + this.field + "\" must be at least " + this.minLength + " long but was only " + this.value.length();
        }

        public StringTooShortException build() {
            return new StringTooShortException(this);
        }
    }
}

