/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tools.cypressmergecoverage.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.nodejs.JHLiteNodePackagesVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;

public class CypressMergeCoverageModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/tools/cypressmergecoverage");
    private static final String CYPRESS_COMPONENT_TESTS = "src/test/webapp/component";

    public JHipsterModule buildCypressMergeCoverage(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("@cypress/code-coverage"), JHLiteNodePackagesVersionSource.COMMON).addDependency(JHipsterModule.packageName("cpy-cli"), JHLiteNodePackagesVersionSource.COMMON).addDependency(JHipsterModule.packageName("rimraf"), JHLiteNodePackagesVersionSource.COMMON).addDependency(JHipsterModule.packageName("vite-plugin-istanbul"), JHLiteNodePackagesVersionSource.COMMON).addDependency(JHipsterModule.packageName("nyc"), JHLiteNodePackagesVersionSource.COMMON).addScript(JHipsterModule.scriptKey("test:coverage:check"), JHipsterModule.scriptCommand("npm-run-all test:coverage:clean test:coverage:copy:* test:coverage:merge test:coverage:report")).addScript(JHipsterModule.scriptKey("test:coverage:clean"), JHipsterModule.scriptCommand("rimraf target/.nyc_output")).addScript(JHipsterModule.scriptKey("test:coverage:copy:unit"), JHipsterModule.scriptCommand("cpy --flat target/frontend-coverage/unit-tests/coverage-final.json target/.nyc_output/ --rename=unit-coverage-final.json")).addScript(JHipsterModule.scriptKey("test:coverage:copy:component"), JHipsterModule.scriptCommand("cpy --flat target/frontend-coverage/components-tests/coverage-final.json target/.nyc_output/ --rename=component-coverage-final.json")).addScript(JHipsterModule.scriptKey("test:coverage:merge"), JHipsterModule.scriptCommand("nyc merge target/.nyc_output target/.nyc_output/frontend-combined-coverage.json")).addScript(JHipsterModule.scriptKey("test:coverage:report"), JHipsterModule.scriptCommand("nyc report --reporter=lcov --reporter=text")).and().apply(this.patchViteConfig()).apply(this.patchVitestConfig()).apply(this.patchCypressConfig(properties)).files().batch(SOURCE, JHipsterModule.to(".")).addTemplate(".nycrc.json").and().batch(SOURCE.append(CYPRESS_COMPONENT_TESTS), JHipsterModule.to(CYPRESS_COMPONENT_TESTS)).addTemplate(".nycrc.json").and().batch(SOURCE.append(CYPRESS_COMPONENT_TESTS).append("support"), JHipsterModule.to(CYPRESS_COMPONENT_TESTS).append("/support")).addFile("component-tests.ts").and().and().build();
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchCypressConfig(JHipsterModuleProperties properties) {
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("src/test/webapp/component/cypress-config.ts")).add(JHipsterModule.fileStart(), "import registerCodeCoverageTasks from '@cypress/code-coverage/task';\n")).add(JHipsterModule.lineAfterRegex("e2e:"), properties.indentation().times(2) + "setupNodeEvents(on, config) {\n      registerCodeCoverageTasks(on, config);\n      return config;\n    },")).add(JHipsterModule.text("supportFile: false"), "supportFile: 'src/test/webapp/component/support/component-tests.ts'");
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchVitestConfig() {
        return moduleBuilder -> moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("vitest.config.ts")).add(JHipsterModule.regex("reportsDirectory: '(.*?)/test-results/'"), "reportsDirectory: 'target/frontend-coverage/unit-tests/'");
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchViteConfig() {
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("vite.config.ts")).add(JHipsterModule.lineAfterRegex("from 'vite'"), "import istanbul from 'vite-plugin-istanbul';")).add(JHipsterModule.text("plugins: ["), "plugins: [istanbul(), ");
    }
}

