/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.frontendmaven.domain;

import org.apache.commons.lang3.StringUtils;
import tech.jhipster.lite.generator.server.javatool.frontendmaven.domain.MavenFrontendPluginExecutions;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.nodejs.NodePackageManager;
import tech.jhipster.lite.module.domain.nodejs.NodeVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class FrontendJavaBuildToolModuleFactory {
    private static final String PACKAGE_INFO = "package-info.java";
    private static final String PROPERTIES_FIELD = "properties";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/frontend");
    private static final String REDIRECTION = "wire/frontend";
    private static final String REDIRECTION_PRIMARY = "wire/frontend/infrastructure/primary";
    private final NodeVersions nodeVersions;

    public FrontendJavaBuildToolModuleFactory(NodeVersions nodeVersions) {
        this.nodeVersions = nodeVersions;
    }

    public JHipsterModule buildFrontendMavenModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        JHipsterModule.JHipsterModuleBuilder moduleBuilder = FrontendJavaBuildToolModuleFactory.commonModuleFiles(properties);
        NodePackageManager nodePackageManager = properties.nodePackageManager();
        if (nodePackageManager == NodePackageManager.NPM) {
            moduleBuilder = moduleBuilder.javaBuildProperties().set(JHipsterModule.buildPropertyKey("npm.version"), JHipsterModule.buildPropertyValue(this.nodeVersions.packageManagerVersion(nodePackageManager).get())).and();
        }
        return moduleBuilder.javaBuildProperties().set(JHipsterModule.buildPropertyKey("node.version"), JHipsterModule.buildPropertyValue("v" + this.nodeVersions.nodeVersion().get())).and().mavenPlugins().plugin(this.frontendMavenPlugin(nodePackageManager).build()).and().build();
    }

    public JHipsterModule buildFrontendMavenCacheModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(this.checksumPlugin()).plugin(this.antrunPlugin(properties.nodePackageManager())).and().build();
    }

    private MavenPlugin checksumPlugin() {
        return JHipsterModule.mavenPlugin().groupId("net.nicoulaj.maven.plugins").artifactId("checksum-maven-plugin").versionSlug("checksum-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("files").id("create-pre-compiled-webapp-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES)).addExecution(JHipsterModule.pluginExecution().goals("files").id("create-compiled-webapp-checksum").phase(MavenBuildPhase.COMPILE).configuration("<csvSummaryFile>checksums.csv.old</csvSummaryFile>\n")).configuration("  <fileSets>\n    <fileSet>\n      <directory>${project.basedir}</directory>\n      <includes>\n        <include>src/main/webapp/**/*.*</include>\n        <include>target/classes/static/**/*.*</include>\n        <include>package-lock.json</include>\n        <include>package.json</include>\n        <include>tsconfig.json</include>\n      </includes>\n    </fileSet>\n  </fileSets>\n  <failOnError>false</failOnError>\n  <failIfNoFiles>false</failIfNoFiles>\n  <individualFiles>false</individualFiles>\n  <algorithms>\n    <algorithm>SHA-1</algorithm>\n  </algorithms>\n  <includeRelativePath>true</includeRelativePath>\n  <quiet>true</quiet>\n").build();
    }

    private MavenPlugin antrunPlugin(NodePackageManager nodePackageManager) {
        String skipProperty = switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> "skip.npm";
            case NodePackageManager.PNPM -> "skip.corepack";
        };
        return JHipsterModule.mavenPlugin().groupId("org.apache.maven.plugins").artifactId("maven-antrun-plugin").versionSlug("maven-antrun-plugin").addExecution(JHipsterModule.pluginExecution().goals("run").id("eval-frontend-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<target>\n  <condition property=\"%s\" value=\"true\" else=\"false\">\n    <and>\n      <available file=\"checksums.csv\" filepath=\"${project.build.directory}\" />\n      <available file=\"checksums.csv.old\" filepath=\"${project.build.directory}\" />\n      <filesmatch file1=\"${project.build.directory}/checksums.csv\" file2=\"${project.build.directory}/checksums.csv.old\" />\n    </and>\n  </condition>\n</target>\n<exportAntProperties>true</exportAntProperties>\n".formatted(skipProperty))).build();
    }

    private MavenPlugin.MavenPluginOptionalBuilder frontendMavenPlugin(NodePackageManager nodePackageManager) {
        return JHipsterModule.mavenPlugin().groupId("com.github.eirslett").artifactId("frontend-maven-plugin").versionSlug("frontend-maven-plugin").configuration("<installDirectory>${project.build.directory}</installDirectory>").addExecution(MavenFrontendPluginExecutions.installNode(nodePackageManager)).addExecution(MavenFrontendPluginExecutions.installPackages(nodePackageManager)).addExecution(MavenFrontendPluginExecutions.buildFront(nodePackageManager)).addExecution(MavenFrontendPluginExecutions.testFront(nodePackageManager));
    }

    public JHipsterModule buildFrontendGradleModule(JHipsterModuleProperties properties) {
        NodePackageManager nodePackageManager = properties.nodePackageManager();
        return FrontendJavaBuildToolModuleFactory.commonModuleFiles(properties).javaBuildProperties().set(JHipsterModule.buildPropertyKey("node.version.value"), JHipsterModule.buildPropertyValue(this.nodeVersions.nodeVersion().get())).set(JHipsterModule.buildPropertyKey("%s.version.value".formatted(new Object[]{nodePackageManager})), JHipsterModule.buildPropertyValue(this.nodeVersions.packageManagerVersion(nodePackageManager).get())).and().gradlePlugins().plugin(this.frontendGradlePlugin(nodePackageManager)).and().gradleConfigurations().addTasksTestInstruction("dependsOn(\"test%s\")".formatted(StringUtils.capitalize((String)nodePackageManager.command()))).and().build();
    }

    public JHipsterModule buildMergeCypressCoverageModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(this.mergeCypressPlugin(properties.nodePackageManager())).and().build();
    }

    private static JHipsterModule.JHipsterModuleBuilder commonModuleFiles(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        String packagePath = properties.packagePath();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath);
        return JHipsterModule.moduleBuilder(properties).files().add(SOURCE.template("RedirectionResource.java"), mainDestination.append(REDIRECTION_PRIMARY).append("RedirectionResource.java")).add(SOURCE.template(PACKAGE_INFO), mainDestination.append(REDIRECTION).append(PACKAGE_INFO)).and();
    }

    private GradleMainBuildPlugin frontendGradlePlugin(NodePackageManager nodePackageManager) {
        String taskImport = switch (nodePackageManager) {
            default -> throw new MatchException(null, null);
            case NodePackageManager.NPM -> "com.github.gradle.node.npm.task.NpmTask";
            case NodePackageManager.PNPM -> "com.github.gradle.node.pnpm.task.PnpmTask";
        };
        return JHipsterModule.gradleCommunityPlugin().id("com.github.node-gradle.node").pluginSlug("node-gradle").versionSlug("node-gradle").withBuildGradleImport(taskImport).configuration("node {\n  download.set(true)\n  version.set(nodeVersionValue)\n  {{nodePackageManager}}Version.set({{nodePackageManager}}VersionValue)\n  workDir.set(file(layout.buildDirectory))\n  {{nodePackageManager}}WorkDir.set(file(layout.buildDirectory))\n}\n\nval buildTaskUsing{{nodePackageManagerCapitalized}} = tasks.register<{{nodePackageManagerCapitalized}}Task>(\"build{{nodePackageManagerCapitalized}}\") {\n  description = \"Build the frontend project using {{nodePackageManager}}\"\n  group = \"Build\"\n  dependsOn(\"{{nodePackageManager}}Install\")\n  {{nodePackageManager}}Command.set(listOf(\"run\", \"build\"))\n  environment.set(mapOf(\"APP_VERSION\" to project.version.toString()))\n}\n\nval testTaskUsing{{nodePackageManagerCapitalized}} = tasks.register<{{nodePackageManagerCapitalized}}Task>(\"test{{nodePackageManagerCapitalized}}\") {\n  description = \"Test the frontend project using {{nodePackageManager}}\"\n  group = \"verification\"\n  dependsOn(\"{{nodePackageManager}}Install\", \"build{{nodePackageManagerCapitalized}}\")\n  {{nodePackageManager}}Command.set(listOf(\"run\", \"test:coverage\"))\n  ignoreExitValue.set(false)\n  workingDir.set(projectDir)\n  execOverrides {\n    standardOutput = System.out\n  }\n}\n\ntasks.bootJar {\n  dependsOn(\"build{{nodePackageManagerCapitalized}}\")\n  from(\"build/classes/static\") {\n      into(\"BOOT-INF/classes/static\")\n  }\n}\n".replace("{{nodePackageManager}}", nodePackageManager.command()).replace("{{nodePackageManagerCapitalized}}", StringUtils.capitalize((String)nodePackageManager.command()))).build();
    }

    private MavenPlugin mergeCypressPlugin(NodePackageManager nodePackageManager) {
        return this.frontendMavenPlugin(nodePackageManager).addExecution(MavenFrontendPluginExecutions.componentTest(nodePackageManager)).addExecution(MavenFrontendPluginExecutions.testCoverageCheck(nodePackageManager)).build();
    }
}

