/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.jacoco.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JacocoModuleFactory {
    private static final String JACOCO = "jacoco";
    private static final GroupId JACOCO_GROUP = JHipsterModule.groupId("org.jacoco");
    private static final ArtifactId JACOCO_ARTIFACT_ID = JHipsterModule.artifactId("jacoco-maven-plugin");
    private static final VersionSlug JACOCO_VERSION = JHipsterModule.versionSlug("jacoco");

    public JHipsterModule buildJacocoModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(JacocoModuleFactory.mavenJacocoPlugin()).pluginManagement(JacocoModuleFactory.mavenJacocoPluginManagement()).and().gradlePlugins().plugin(JacocoModuleFactory.gradleJacocoPlugin()).and().gradleConfigurations().addTasksTestInstruction("finalizedBy(\"jacocoTestReport\")").and().build();
    }

    public JHipsterModule buildJacocoWithMinCoverageCheckModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(JacocoModuleFactory.mavenJacocoPlugin()).pluginManagement(JacocoModuleFactory.mavenJacocoWithMinCoverageCheckPluginManagement()).and().gradlePlugins().plugin(JacocoModuleFactory.gradleJacocoWithMinCoverageCheckPlugin()).and().gradleConfigurations().addTasksTestInstruction("finalizedBy(\"jacocoTestCoverageVerification\")").and().build();
    }

    private static MavenPlugin mavenJacocoPlugin() {
        return JHipsterModule.mavenPlugin().groupId(JACOCO_GROUP).artifactId(JACOCO_ARTIFACT_ID).build();
    }

    private static MavenPlugin mavenJacocoPluginManagement() {
        return JacocoModuleFactory.commonMavenJacocoPluginManagement().build();
    }

    private static MavenPlugin mavenJacocoWithMinCoverageCheckPluginManagement() {
        return JacocoModuleFactory.commonMavenJacocoPluginManagement().addExecution(JHipsterModule.pluginExecution().goals("check").id("check").configuration("  <dataFile>target/jacoco/allTest.exec</dataFile>\n  <rules>\n    <rule>\n      <element>CLASS</element>\n      <limits>\n        <limit>\n          <counter>BRANCH</counter>\n          <value>MISSEDCOUNT</value>\n          <maximum>0</maximum>\n        </limit>\n        <limit>\n          <counter>LINE</counter>\n          <value>MISSEDCOUNT</value>\n          <maximum>0</maximum>\n        </limit>\n      </limits>\n    </rule>\n  </rules>\n")).build();
    }

    private static MavenPlugin.MavenPluginOptionalBuilder commonMavenJacocoPluginManagement() {
        return JHipsterModule.mavenPlugin().groupId(JACOCO_GROUP).artifactId(JACOCO_ARTIFACT_ID).versionSlug(JACOCO_VERSION).addExecution(JHipsterModule.pluginExecution().goals("prepare-agent").id("pre-unit-tests")).addExecution(JHipsterModule.pluginExecution().goals("report").id("post-unit-test").phase(MavenBuildPhase.TEST)).addExecution(JHipsterModule.pluginExecution().goals("prepare-agent-integration").id("pre-integration-tests")).addExecution(JHipsterModule.pluginExecution().goals("report-integration").id("post-integration-tests").phase(MavenBuildPhase.POST_INTEGRATION_TEST)).addExecution(JHipsterModule.pluginExecution().goals("merge").id("merge").phase(MavenBuildPhase.VERIFY).configuration("  <fileSets>\n  <fileSet implementation=\"org.apache.maven.shared.model.fileset.FileSet\">\n    <directory>${project.basedir}</directory>\n    <includes>\n      <include>**/*.exec</include>\n    </includes>\n  </fileSet>\n</fileSets>\n<destFile>target/jacoco/allTest.exec</destFile>\n")).addExecution(JHipsterModule.pluginExecution().goals("report").id("post-merge-report").phase(MavenBuildPhase.VERIFY).configuration("  <dataFile>target/jacoco/allTest.exec</dataFile>\n  <outputDirectory>target/jacoco/</outputDirectory>\n"));
    }

    private static GradleMainBuildPlugin gradleJacocoPlugin() {
        return JHipsterModule.gradleCorePlugin().id(JACOCO).toolVersionSlug(JACOCO).configuration("jacoco {\n  toolVersion = libs.versions.jacoco.get()\n}\n\ntasks.jacocoTestReport {\n  dependsOn(\"test\", \"integrationTest\")\n  reports {\n    xml.required.set(true)\n    html.required.set(true)\n  }\n  executionData.setFrom(fileTree(layout.buildDirectory).include(\"**/jacoco/test.exec\", \"**/jacoco/integrationTest.exec\"))\n}\n").build();
    }

    private static GradleMainBuildPlugin gradleJacocoWithMinCoverageCheckPlugin() {
        return JHipsterModule.gradleCorePlugin().id(JACOCO).toolVersionSlug(JACOCO).configuration("jacoco {\n  toolVersion = libs.versions.jacoco.get()\n}\n\ntasks.jacocoTestReport {\n  dependsOn(\"test\", \"integrationTest\")\n  reports {\n    xml.required.set(true)\n    html.required.set(true)\n  }\n  executionData.setFrom(fileTree(layout.buildDirectory).include(\"**/jacoco/test.exec\", \"**/jacoco/integrationTest.exec\"))\n}\n\ntasks.jacocoTestCoverageVerification {\n  dependsOn(\"jacocoTestReport\")\n  violationRules {\n\n      rule {\n          element = \"CLASS\"\n\n          limit {\n              counter = \"LINE\"\n              value = \"MISSEDCOUNT\"\n              maximum = \"0.00\".toBigDecimal()\n          }\n\n          limit {\n              counter = \"BRANCH\"\n              value = \"MISSEDCOUNT\"\n              maximum = \"0.00\".toBigDecimal()\n          }\n      }\n  }\n  executionData.setFrom(fileTree(layout.buildDirectory).include(\"**/jacoco/test.exec\", \"**/jacoco/integrationTest.exec\"))\n}\n").build();
    }
}

