/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.datasource.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.generator.server.springboot.database.datasource.domain.DatasourceProperties;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageName;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class DatasourceModuleFactory {
    private static final String PROPERTIES = "properties";
    private static final String ORG_POSTGRESQL = "org.postgresql";
    private static final String POSTGRESQL = "postgresql";
    private static final String MYSQL = "mysql";
    private static final String MARIADB = "mariadb";
    private static final String SPRING_DATASOURCE_URL = "spring.datasource.url";
    private static final String SPRING_DATASOURCE_USERNAME = "spring.datasource.username";
    private static final String SPRING_DATASOURCE_PASSWORD = "spring.datasource.password";
    private static final String SPRING_DATASOURCE_DRIVER_CLASS_NAME = "spring.datasource.driver-class-name";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/database/datasource");
    private final DockerImages dockerImages;

    public DatasourceModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildPostgreSQL(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        DatasourceProperties datasourceProperties = DatasourceProperties.builder().id(POSTGRESQL).databaseName("PostgreSQL").driverDependency(JHipsterModule.javaDependency().groupId(ORG_POSTGRESQL).artifactId(POSTGRESQL).scope(JavaDependencyScope.RUNTIME).build()).driverClassName("org.postgresql.Driver").dockerImageName(new DockerImageName("postgres")).testContainerArtifactId(JHipsterModule.artifactId(POSTGRESQL));
        DockerImageVersion dockerImage = this.dockerImages.get(datasourceProperties.dockerImageName());
        return JHipsterModule.moduleBuilder(properties).apply(DatasourceModuleFactory.dockerContainer(this.dockerImages, datasourceProperties)).apply(DatasourceModuleFactory.declareDockerComposeService(datasourceProperties)).apply(DatasourceModuleFactory.connectionPool(datasourceProperties)).apply(DatasourceModuleFactory.testcontainers(this.dockerImages, properties, datasourceProperties)).springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue(properties.projectBaseName().name())).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:postgresql:" + dockerImage.version().get() + ":///" + properties.projectBaseName().name() + "?TC_TMPFS=/testtmpfs:rw")).and().springMainLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger("org.jboss.logging", LogLevel.WARN).build();
    }

    public JHipsterModule buildMariaDB(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        DatasourceProperties datasourceProperties = DatasourceProperties.builder().id(MARIADB).databaseName("MariaDB").driverDependency(JHipsterModule.javaDependency().groupId("org.mariadb.jdbc").artifactId("mariadb-java-client").scope(JavaDependencyScope.RUNTIME).build()).driverClassName("org.mariadb.jdbc.Driver").dockerImageName(new DockerImageName(MARIADB)).testContainerArtifactId(JHipsterModule.artifactId(MARIADB));
        return JHipsterModule.moduleBuilder(properties).apply(DatasourceModuleFactory.dockerContainer(this.dockerImages, datasourceProperties)).apply(DatasourceModuleFactory.declareDockerComposeService(datasourceProperties)).apply(DatasourceModuleFactory.connectionPool(datasourceProperties)).apply(DatasourceModuleFactory.testcontainers(this.dockerImages, properties, datasourceProperties)).springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).and().build();
    }

    public JHipsterModule buildMySQL(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        DatasourceProperties datasourceProperties = DatasourceProperties.builder().id(MYSQL).databaseName("MySQL").driverDependency(JHipsterModule.javaDependency().groupId("com.mysql").artifactId("mysql-connector-j").scope(JavaDependencyScope.RUNTIME).build()).driverClassName("com.mysql.cj.jdbc.Driver").dockerImageName(new DockerImageName(MYSQL)).testContainerArtifactId(JHipsterModule.artifactId(MYSQL));
        return JHipsterModule.moduleBuilder(properties).apply(DatasourceModuleFactory.dockerContainer(this.dockerImages, datasourceProperties)).apply(DatasourceModuleFactory.declareDockerComposeService(datasourceProperties)).apply(DatasourceModuleFactory.connectionPool(datasourceProperties)).apply(DatasourceModuleFactory.testcontainers(this.dockerImages, properties, datasourceProperties)).springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mysql://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).and().build();
    }

    public JHipsterModule buildMsSQL(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        DatasourceProperties datasourceProperties = DatasourceProperties.builder().id("mssql").databaseName("MsSQL").driverDependency(JHipsterModule.javaDependency().groupId("com.microsoft.sqlserver").artifactId("mssql-jdbc").scope(JavaDependencyScope.RUNTIME).build()).driverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver").dockerImageName(new DockerImageName("mcr.microsoft.com/mssql/server")).testContainerArtifactId(JHipsterModule.artifactId("mssqlserver"));
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).apply(DatasourceModuleFactory.dockerContainer(this.dockerImages, datasourceProperties)).apply(DatasourceModuleFactory.declareDockerComposeService(datasourceProperties)).apply(DatasourceModuleFactory.connectionPool(datasourceProperties)).apply(DatasourceModuleFactory.testcontainers(this.dockerImages, properties, datasourceProperties)).files().add(SOURCE.append("docker").template("container-license-acceptance.txt"), JHipsterModule.to("src/test/resources/container-license-acceptance.txt")).add(SOURCE.template("MsSQLTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(properties.basePackage().path()).append("MsSQLTestContainerExtension.java")).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_PASSWORD), JHipsterModule.propertyValue("yourStrong(!)Password")).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:sqlserver:///;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true?TC_TMPFS=/testtmpfs:rw")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_PASSWORD), JHipsterModule.propertyValue("yourStrong(!)Password")).and().mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(properties.basePackage().path()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(MsSQLTestContainerExtension.class)")).and()).and().springMainLogger("com.microsoft.sqlserver", LogLevel.WARN).springMainLogger("org.reflections", LogLevel.WARN).build();
    }

    public static Consumer<JHipsterModule.JHipsterModuleBuilder> declareDockerComposeService(DatasourceProperties datasourceProperties) {
        return moduleBuilder -> moduleBuilder.dockerComposeFile().append(JHipsterModule.dockerComposeFile("src/main/docker/%s.yml".formatted(datasourceProperties.id())));
    }

    public static Consumer<JHipsterModule.JHipsterModuleBuilder> dockerContainer(DockerImages dockerImages, DatasourceProperties datasourceProperties) {
        DockerImageVersion dockerImage = dockerImages.get(datasourceProperties.dockerImageName());
        return moduleBuilder -> moduleBuilder.context().put("srcMainDocker", "src/main/docker").put("databaseType", datasourceProperties.id()).put(datasourceProperties.id() + "DockerImageWithVersion", dockerImage.fullName()).and().documentation(JHipsterModule.documentationTitle(datasourceProperties.databaseName()), SOURCE.template("databaseType.md")).startupCommands().dockerCompose("src/main/docker/" + datasourceProperties.id() + ".yml").and().files().add(SOURCE.append("docker").template(datasourceProperties.id() + ".yml"), JHipsterModule.toSrcMainDocker().append(datasourceProperties.id() + ".yml"));
    }

    public static Consumer<JHipsterModule.JHipsterModuleBuilder> testcontainers(DockerImages dockerImages, JHipsterModuleProperties moduleProperties, DatasourceProperties datasourceProperties) {
        DockerImageVersion dockerImage = dockerImages.get(datasourceProperties.dockerImageName());
        return moduleBuilder -> moduleBuilder.javaDependencies().addDependency(datasourceProperties.testContainerDependency()).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:" + dockerImage.fullName() + ":///" + moduleProperties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue(moduleProperties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_PASSWORD), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("org.testcontainers.jdbc.ContainerDatabaseDriver")).and().springTestLogger("com.github.dockerjava", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN);
    }

    public static Consumer<JHipsterModule.JHipsterModuleBuilder> connectionPool(DatasourceProperties datasourceProperties) {
        return moduleBuilder -> moduleBuilder.javaDependencies().addDependency(datasourceProperties.driverDependency()).addDependency(JHipsterModule.groupId("com.zaxxer"), JHipsterModule.artifactId("HikariCP")).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_PASSWORD), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey("spring.datasource.type"), JHipsterModule.propertyValue("com.zaxxer.hikari.HikariDataSource")).set(JHipsterModule.propertyKey("spring.datasource.hikari.poolName"), JHipsterModule.propertyValue("Hikari")).set(JHipsterModule.propertyKey("spring.datasource.hikari.auto-commit"), JHipsterModule.propertyValue(false)).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue(datasourceProperties.driverClassName())).and().springTestProperties().set(JHipsterModule.propertyKey("spring.datasource.hikari.maximum-pool-size"), JHipsterModule.propertyValue(2));
    }
}

