/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.application;

import java.util.Collection;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.GeneratedProjectRepository;
import tech.jhipster.lite.module.domain.JHipsterModuleApplied;
import tech.jhipster.lite.module.domain.JHipsterModuleEvents;
import tech.jhipster.lite.module.domain.JHipsterModuleToApply;
import tech.jhipster.lite.module.domain.JHipsterModulesApplyer;
import tech.jhipster.lite.module.domain.JHipsterModulesRepository;
import tech.jhipster.lite.module.domain.JHipsterModulesToApply;
import tech.jhipster.lite.module.domain.JHipsterPresetRepository;
import tech.jhipster.lite.module.domain.git.GitRepository;
import tech.jhipster.lite.module.domain.javabuild.ProjectJavaBuildToolRepository;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersionsRepository;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesRepository;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscape;
import tech.jhipster.lite.module.domain.preset.Presets;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;

@Service
public class JHipsterModulesApplicationService {
    private final JHipsterModuleEvents events;
    private final JHipsterModulesRepository modules;
    private final JHipsterModulesApplyer applyer;
    private final JHipsterPresetRepository preset;

    public JHipsterModulesApplicationService(JHipsterModuleEvents events, JHipsterModulesRepository modules, JavaDependenciesVersionsRepository currentVersions, ProjectJavaDependenciesRepository projectDependencies, ProjectJavaBuildToolRepository javaBuildTools, GitRepository git, GeneratedProjectRepository generatedProject, JHipsterPresetRepository preset) {
        this.events = events;
        this.modules = modules;
        this.preset = preset;
        this.applyer = new JHipsterModulesApplyer(modules, currentVersions, projectDependencies, javaBuildTools, git, generatedProject);
    }

    public void apply(JHipsterModulesToApply modulesToApply) {
        Collection<JHipsterModuleApplied> modulesApplied = this.applyer.apply(modulesToApply);
        modulesApplied.forEach(this.events::dispatch);
    }

    public void apply(JHipsterModuleToApply moduleToApply) {
        JHipsterModuleApplied moduleApplied = this.applyer.apply(moduleToApply);
        this.events.dispatch(moduleApplied);
    }

    public JHipsterModulesResources resources() {
        return this.modules.resources();
    }

    public JHipsterLandscape landscape() {
        return this.modules.landscape();
    }

    public Presets getPresets() {
        return this.preset.getPresets();
    }
}

