/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.jhipster.lite.module.domain.InvalidJHipsterSlugException;
import tech.jhipster.lite.module.domain.JHipsterFeatureSlug;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public abstract sealed class JHipsterSlug
implements Comparable<JHipsterSlug>
permits JHipsterModuleSlug, JHipsterFeatureSlug {
    private static final Pattern SLUG_FORMAT = Pattern.compile("^[a-z0-9-]+$");
    private final String slug;

    protected JHipsterSlug(String slug) {
        Assert.field("slug", slug).notBlank().matchesPatternOrThrow(SLUG_FORMAT, () -> new InvalidJHipsterSlugException(slug));
        this.slug = slug;
    }

    public String get() {
        return this.slug;
    }

    @Override
    public int compareTo(JHipsterSlug other) {
        if (this.isInit()) {
            return -1;
        }
        if (other.isInit()) {
            return 1;
        }
        return this.get().compareTo(other.get());
    }

    private boolean isInit() {
        return this.get().equals("init");
    }

    @ExcludeFromGeneratedCodeCoverage
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.slug).hashCode();
    }

    @ExcludeFromGeneratedCodeCoverage
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JHipsterSlug)) {
            return false;
        }
        JHipsterSlug other = (JHipsterSlug)obj;
        return new EqualsBuilder().append((Object)this.slug, (Object)other.slug).isEquals();
    }
}

