/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gradleplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import tech.jhipster.lite.module.domain.gradleplugin.BuildGradleImport;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginConfiguration;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginDependency;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginId;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginImports;
import tech.jhipster.lite.module.domain.gradleplugin.GradleProfilePlugin;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class GradleCommunityProfilePlugin
implements GradleProfilePlugin {
    private final GradlePluginId id;
    private final GradlePluginDependency dependency;
    private final GradlePluginImports imports;
    private final Optional<GradlePluginConfiguration> configuration;
    private final Optional<VersionSlug> versionSlug;

    private GradleCommunityProfilePlugin(GradleCommunityProfilePluginBuilder builder) {
        Assert.notNull("id", builder.id);
        Assert.notNull("dependencyId", builder.dependency);
        this.id = builder.id;
        this.dependency = builder.dependency;
        this.imports = new GradlePluginImports(builder.imports);
        this.configuration = Optional.ofNullable(builder.configuration);
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
    }

    @Override
    public GradlePluginId id() {
        return this.id;
    }

    @Override
    public GradlePluginImports imports() {
        return this.imports;
    }

    @Override
    public Optional<GradlePluginConfiguration> configuration() {
        return this.configuration;
    }

    public GradlePluginDependency dependency() {
        return this.dependency;
    }

    public Optional<VersionSlug> versionSlug() {
        return this.versionSlug;
    }

    public static GradleCommunityProfilePluginIdBuilder builder() {
        return new GradleCommunityProfilePluginBuilder();
    }

    private static final class GradleCommunityProfilePluginBuilder
    implements GradleCommunityProfilePluginIdBuilder,
    GradleCommunityProfilePluginDependencyBuilder,
    GradleCommunityProfilePluginOptionalBuilder {
        private GradlePluginId id;
        private GradlePluginDependency dependency;
        private final Collection<BuildGradleImport> imports = new ArrayList<BuildGradleImport>();
        private GradlePluginConfiguration configuration;
        private VersionSlug versionSlug;

        private GradleCommunityProfilePluginBuilder() {
        }

        @Override
        public GradleCommunityProfilePluginDependencyBuilder id(GradlePluginId id) {
            this.id = id;
            return this;
        }

        @Override
        public GradleCommunityProfilePluginOptionalBuilder dependency(GradlePluginDependency dependency) {
            this.dependency = dependency;
            return this;
        }

        @Override
        public GradleCommunityProfilePluginOptionalBuilder withBuildGradleImport(BuildGradleImport gradleImport) {
            this.imports.add(gradleImport);
            return this;
        }

        @Override
        public GradleCommunityProfilePluginOptionalBuilder configuration(GradlePluginConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GradleCommunityProfilePluginOptionalBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public GradleCommunityProfilePlugin build() {
            return new GradleCommunityProfilePlugin(this);
        }
    }

    public static interface GradleCommunityProfilePluginOptionalBuilder {
        public GradleCommunityProfilePluginOptionalBuilder withBuildGradleImport(BuildGradleImport var1);

        default public GradleCommunityProfilePluginOptionalBuilder withBuildGradleImport(String gradleImport) {
            return this.withBuildGradleImport(new BuildGradleImport(gradleImport));
        }

        public GradleCommunityProfilePluginOptionalBuilder configuration(GradlePluginConfiguration var1);

        default public GradleCommunityProfilePluginOptionalBuilder configuration(String configuration) {
            return this.configuration(new GradlePluginConfiguration(configuration));
        }

        public GradleCommunityProfilePluginOptionalBuilder versionSlug(VersionSlug var1);

        default public GradleCommunityProfilePluginOptionalBuilder versionSlug(String versionSlug) {
            return this.versionSlug(new VersionSlug(versionSlug));
        }

        public GradleCommunityProfilePlugin build();
    }

    public static interface GradleCommunityProfilePluginDependencyBuilder {
        public GradleCommunityProfilePluginOptionalBuilder dependency(GradlePluginDependency var1);

        default public GradleCommunityProfilePluginOptionalBuilder dependency(GroupId groupId, ArtifactId artifactId) {
            return this.dependency(new GradlePluginDependency(groupId, artifactId));
        }
    }

    public static interface GradleCommunityProfilePluginIdBuilder {
        public GradleCommunityProfilePluginDependencyBuilder id(GradlePluginId var1);

        default public GradleCommunityProfilePluginDependencyBuilder id(String id) {
            return this.id(new GradlePluginId(id));
        }
    }
}

