/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuild;

import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public final class MavenBuildExtension {
    private final GroupId groupId;
    private final ArtifactId artifactId;
    private final Optional<VersionSlug> versionSlug;

    private MavenBuildExtension(MavenBuildExtensionBuilder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
    }

    public static MavenBuildExtensionGroupIdBuilder builder() {
        return new MavenBuildExtensionBuilder();
    }

    public Optional<VersionSlug> versionSlug() {
        return this.versionSlug;
    }

    public GroupId groupId() {
        return this.groupId;
    }

    public ArtifactId artifactId() {
        return this.artifactId;
    }

    @ExcludeFromGeneratedCodeCoverage
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.groupId).append((Object)this.artifactId).append(this.versionSlug).hashCode();
    }

    @ExcludeFromGeneratedCodeCoverage
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MavenBuildExtension other = (MavenBuildExtension)obj;
        return new EqualsBuilder().append((Object)this.groupId, (Object)other.groupId).append((Object)this.artifactId, (Object)other.artifactId).append(this.versionSlug, other.versionSlug).isEquals();
    }

    private static final class MavenBuildExtensionBuilder
    implements MavenBuildExtensionGroupIdBuilder,
    MavenBuildExtensionArtifactIdBuilder,
    MavenBuildExtensionOptionalValueBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private VersionSlug versionSlug;

        private MavenBuildExtensionBuilder() {
        }

        @Override
        public MavenBuildExtensionArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public MavenBuildExtensionOptionalValueBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public MavenBuildExtensionOptionalValueBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public MavenBuildExtension build() {
            return new MavenBuildExtension(this);
        }
    }

    public static interface MavenBuildExtensionOptionalValueBuilder {
        public MavenBuildExtensionOptionalValueBuilder versionSlug(VersionSlug var1);

        public MavenBuildExtension build();

        default public MavenBuildExtensionOptionalValueBuilder versionSlug(String versionSlug) {
            return this.versionSlug((VersionSlug)VersionSlug.of(versionSlug).orElse(null));
        }
    }

    public static interface MavenBuildExtensionArtifactIdBuilder {
        public MavenBuildExtensionOptionalValueBuilder artifactId(ArtifactId var1);

        default public MavenBuildExtensionOptionalValueBuilder artifactId(String artifactId) {
            return this.artifactId(new ArtifactId(artifactId));
        }
    }

    public static interface MavenBuildExtensionGroupIdBuilder {
        public MavenBuildExtensionArtifactIdBuilder groupId(GroupId var1);

        default public MavenBuildExtensionArtifactIdBuilder groupId(String groupId) {
            return this.groupId(new GroupId(groupId));
        }
    }
}

