/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.DirectJavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyManagement;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JHipsterModuleJavaDependencies {
    private final Collection<DependencyId> dependenciesToRemove;
    private final Collection<JavaDependencyManagement> dependenciesManagement;
    private final Collection<DependencyId> dependenciesManagementToRemove;
    private final Collection<DirectJavaDependency> dependencies;

    private JHipsterModuleJavaDependencies(JHipsterModuleJavaDependenciesBuilder<?> builder) {
        this.dependenciesToRemove = builder.dependenciesToRemove;
        this.dependenciesManagement = builder.dependenciesManagement;
        this.dependenciesManagementToRemove = builder.dependenciesManagementToRemove;
        this.dependencies = builder.dependencies;
    }

    public static <M> JHipsterModuleJavaDependenciesBuilder<M> builder(M module) {
        return new JHipsterModuleJavaDependenciesBuilder<M>(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectDependencies) {
        return this.buildChanges(versions, projectDependencies, Optional.empty());
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies, BuildProfileId buildProfile) {
        Assert.notNull("buildProfile", buildProfile);
        return this.buildChanges(versions, projectJavaDependencies, Optional.of(buildProfile));
    }

    private JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectDependencies, Optional<BuildProfileId> buildProfile) {
        Assert.notNull("versions", versions);
        Assert.notNull("projectDependencies", projectDependencies);
        return Stream.of(this.dependenciesToRemoveCommands(buildProfile), this.dependenciesManagementChanges(versions, projectDependencies, buildProfile), this.dependenciesManagementToRemoveCommands(buildProfile), this.dependenciesChanges(versions, projectDependencies, buildProfile)).flatMap(Function.identity()).reduce(JavaBuildCommands.EMPTY, JavaBuildCommands::merge);
    }

    private Stream<JavaBuildCommands> dependenciesToRemoveCommands(Optional<BuildProfileId> buildProfile) {
        return Stream.of(new JavaBuildCommands(this.dependenciesToRemove.stream().map(this.toDependencyToRemove(buildProfile)).toList()));
    }

    private Function<DependencyId, JavaBuildCommand> toDependencyToRemove(Optional<BuildProfileId> buildProfile) {
        return dependency -> new RemoveDirectJavaDependency((DependencyId)dependency, buildProfile);
    }

    private Stream<JavaBuildCommands> dependenciesManagementChanges(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies, Optional<BuildProfileId> buildProfile) {
        return this.dependenciesManagement.stream().map(dependency -> dependency.changeCommands(currentVersions, projectDependencies, buildProfile));
    }

    private Stream<JavaBuildCommands> dependenciesManagementToRemoveCommands(Optional<BuildProfileId> buildProfile) {
        return Stream.of(new JavaBuildCommands(this.dependenciesManagementToRemove.stream().map(this.toDependencyManagementToRemove(buildProfile)).toList()));
    }

    private Function<DependencyId, JavaBuildCommand> toDependencyManagementToRemove(Optional<BuildProfileId> buildProfile) {
        return dependency -> new RemoveJavaDependencyManagement((DependencyId)dependency, buildProfile);
    }

    private Stream<JavaBuildCommands> dependenciesChanges(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies, Optional<BuildProfileId> buildProfile) {
        return this.dependencies.stream().map(dependency -> dependency.changeCommands(currentVersions, projectDependencies, buildProfile));
    }

    public static final class JHipsterModuleJavaDependenciesBuilder<T> {
        private static final String DEPENDENCY = "dependency";
        private final T parentModuleBuilder;
        private final Collection<DependencyId> dependenciesToRemove = new ArrayList<DependencyId>();
        private final Collection<DirectJavaDependency> dependencies = new ArrayList<DirectJavaDependency>();
        private final Collection<JavaDependencyManagement> dependenciesManagement = new ArrayList<JavaDependencyManagement>();
        private final Collection<DependencyId> dependenciesManagementToRemove = new ArrayList<DependencyId>();

        private JHipsterModuleJavaDependenciesBuilder(T parentModuleBuilder) {
            Assert.notNull("module", parentModuleBuilder);
            this.parentModuleBuilder = parentModuleBuilder;
        }

        public JHipsterModuleJavaDependenciesBuilder<T> removeDependency(DependencyId dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependenciesToRemove.add(dependency);
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder<T> addDependency(GroupId groupId, ArtifactId artifactId) {
            return this.addDependency(groupId, artifactId, null);
        }

        public JHipsterModuleJavaDependenciesBuilder<T> addDependency(GroupId groupId, ArtifactId artifactId, VersionSlug versionSlug) {
            JavaDependency dependency = JavaDependency.builder().groupId(groupId).artifactId(artifactId).versionSlug(versionSlug).build();
            return this.addDependency(dependency);
        }

        public JHipsterModuleJavaDependenciesBuilder<T> addTestDependency(GroupId groupId, ArtifactId artifactId, VersionSlug versionSlug) {
            JavaDependency dependency = JavaDependency.builder().groupId(groupId).artifactId(artifactId).versionSlug(versionSlug).scope(JavaDependencyScope.TEST).build();
            return this.addDependency(dependency);
        }

        public JHipsterModuleJavaDependenciesBuilder<T> addDependency(JavaDependency dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependencies.add(new DirectJavaDependency(dependency));
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder<T> addDependencyManagement(JavaDependency dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependenciesManagement.add(new JavaDependencyManagement(dependency));
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder<T> removeDependencyManagement(DependencyId dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependenciesManagementToRemove.add(dependency);
            return this;
        }

        public T and() {
            return this.parentModuleBuilder;
        }

        public JHipsterModuleJavaDependencies build() {
            return new JHipsterModuleJavaDependencies(this);
        }
    }
}

