/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.landscape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterFeatureSlug;
import tech.jhipster.lite.module.domain.JHipsterSlug;
import tech.jhipster.lite.module.domain.landscape.InvalidLandscapeException;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependencies;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependency;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeElement;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeFeature;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeLevel;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeModule;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;
import tech.jhipster.lite.shared.error.domain.Assert;

public record JHipsterLandscapeLevels(Collection<JHipsterLandscapeLevel> levels) {
    public JHipsterLandscapeLevels(Collection<JHipsterLandscapeLevel> levels) {
        Assert.notEmpty("levels", levels);
        this.levels = Collections.unmodifiableCollection(levels);
    }

    static JHipsterLandscapeLevelsBuilder builder() {
        return new JHipsterLandscapeLevelsBuilder();
    }

    public Collection<JHipsterLandscapeLevel> get() {
        return this.levels();
    }

    public Stream<JHipsterLandscapeLevel> stream() {
        return this.levels().stream();
    }

    static class JHipsterLandscapeLevelsBuilder {
        private final Map<JHipsterFeatureSlug, Collection<JHipsterLandscapeModule>> features = new ConcurrentHashMap<JHipsterFeatureSlug, Collection<JHipsterLandscapeModule>>();
        private final Collection<JHipsterLandscapeModule> modules = new ArrayList<JHipsterLandscapeModule>();

        JHipsterLandscapeLevelsBuilder() {
        }

        JHipsterLandscapeLevelsBuilder resources(JHipsterModulesResources resources) {
            Assert.notNull("resources", resources);
            resources.stream().forEach(this::append);
            return this;
        }

        private JHipsterLandscapeLevelsBuilder append(JHipsterModuleResource resource) {
            Assert.notNull("resource", resource);
            resource.organization().feature().ifPresentOrElse(this.addFeature(resource), this.addModule(resource));
            return this;
        }

        private Consumer<JHipsterFeatureSlug> addFeature(JHipsterModuleResource resource) {
            return feature -> this.features.computeIfAbsent((JHipsterFeatureSlug)feature, this.newArrayList()).add(JHipsterLandscapeLevelsBuilder.landscapeModule(resource));
        }

        private Function<JHipsterFeatureSlug, Collection<JHipsterLandscapeModule>> newArrayList() {
            return key -> new ArrayList();
        }

        private Runnable addModule(JHipsterModuleResource resource) {
            return () -> this.modules.add(JHipsterLandscapeLevelsBuilder.landscapeModule(resource));
        }

        private static JHipsterLandscapeModule landscapeModule(JHipsterModuleResource resource) {
            return JHipsterLandscapeModule.builder().module(resource.slug()).operation(resource.apiDoc().operation()).propertiesDefinition(resource.propertiesDefinition()).rank(resource.rank()).dependencies(resource.organization().dependencies());
        }

        public JHipsterLandscapeLevels build() {
            List<JHipsterLandscapeElement> elements = Stream.concat(this.features.entrySet().stream().map(this.toFeature()), this.modules.stream()).toList();
            JHipsterLandscapeLevelsDispatcher dispatcher = new JHipsterLandscapeLevelsDispatcher(elements);
            dispatcher.buildRoot();
            while (dispatcher.hasRemainingElements()) {
                dispatcher.dispatchNextLevel();
            }
            return new JHipsterLandscapeLevels(dispatcher.levels());
        }

        private Function<Map.Entry<JHipsterFeatureSlug, Collection<JHipsterLandscapeModule>>, JHipsterLandscapeFeature> toFeature() {
            return entry -> new JHipsterLandscapeFeature((JHipsterFeatureSlug)entry.getKey(), (Collection)entry.getValue());
        }
    }

    private static final class JHipsterLandscapeLevelsDispatcher {
        private final List<JHipsterLandscapeLevel> levels = new ArrayList<JHipsterLandscapeLevel>();
        private List<JHipsterLandscapeElement> elementsToDispatch;

        private JHipsterLandscapeLevelsDispatcher(List<JHipsterLandscapeElement> elements) {
            this.elementsToDispatch = elements;
        }

        private void buildRoot() {
            List<JHipsterLandscapeElement> rootElements = this.levelElements(this.withoutDependencies());
            if (rootElements.isEmpty()) {
                throw InvalidLandscapeException.missingRootElement();
            }
            this.appendLevel(rootElements);
        }

        private Predicate<JHipsterLandscapeElement> withoutDependencies() {
            return element -> element.dependencies().isEmpty();
        }

        private boolean hasRemainingElements() {
            return !this.elementsToDispatch.isEmpty();
        }

        private void dispatchNextLevel() {
            Set<JHipsterSlug> knownSlugs = this.knownSlugs();
            List<JHipsterLandscapeElement> levelElements = this.levelElements(this.withAllKnownDependencies(knownSlugs));
            if (levelElements.isEmpty()) {
                throw InvalidLandscapeException.unknownDependency(knownSlugs, this.elementsToDispatch.stream().map(JHipsterLandscapeElement::slug).toList());
            }
            this.appendLevel(levelElements);
        }

        private List<JHipsterLandscapeElement> levelElements(Predicate<JHipsterLandscapeElement> condition) {
            return this.elementsToDispatch.stream().filter(condition).toList();
        }

        private Predicate<JHipsterLandscapeElement> withAllKnownDependencies(Set<JHipsterSlug> knownSlugs) {
            return element -> knownSlugs.containsAll(element.dependencies().stream().flatMap(JHipsterLandscapeDependencies::stream).map(JHipsterLandscapeDependency::slug).toList());
        }

        private Set<JHipsterSlug> knownSlugs() {
            return this.levels.stream().flatMap(JHipsterLandscapeLevel::slugs).collect(Collectors.toSet());
        }

        private void appendLevel(List<JHipsterLandscapeElement> elements) {
            this.updateElementsToDispatch(elements);
            this.levels.add(new JHipsterLandscapeLevel(elements));
        }

        private void updateElementsToDispatch(List<JHipsterLandscapeElement> elements) {
            this.elementsToDispatch = this.elementsToDispatch.stream().filter(element -> !elements.contains(element)).toList();
        }

        private Collection<JHipsterLandscapeLevel> levels() {
            return this.levels;
        }
    }
}

