/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.nodejs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import tech.jhipster.lite.module.domain.nodejs.NodePackage;
import tech.jhipster.lite.module.domain.nodejs.NodePackageName;
import tech.jhipster.lite.module.domain.nodejs.NodePackageVersion;
import tech.jhipster.lite.module.domain.nodejs.NodePackagesVersionSource;
import tech.jhipster.lite.module.domain.nodejs.UnknownNodePackageException;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class NodePackagesVersions {
    public static final NodePackagesVersions EMPTY = NodePackagesVersions.builder().build();
    private final Map<NodePackagesVersionSource, NodePackagesSourceVersions> versions;

    private NodePackagesVersions(NpmPackagesVersionsBuilder builder) {
        this.versions = Collections.unmodifiableMap(builder.versions);
    }

    private NodePackagesVersions(Map<NodePackagesVersionSource, NodePackagesSourceVersions> versions) {
        this.versions = Collections.unmodifiableMap(versions);
    }

    public static NpmPackagesVersionsBuilder builder() {
        return new NpmPackagesVersionsBuilder();
    }

    public NodePackageVersion get(NodePackageName packageName, NodePackagesVersionSource source) {
        Assert.notNull("packageName", packageName);
        Assert.notNull("source", source);
        return Optional.ofNullable(this.versions.get(source)).orElseThrow(() -> new UnknownNodePackageException(packageName, source)).get(packageName);
    }

    public NodePackagesVersions merge(NodePackagesVersions other) {
        Assert.notNull("other", other);
        HashMap<NodePackagesVersionSource, NodePackagesSourceVersions> mergedVersions = new HashMap<NodePackagesVersionSource, NodePackagesSourceVersions>();
        other.versions.forEach((source, packages) -> mergedVersions.computeIfAbsent((NodePackagesVersionSource)source, NodePackagesSourceVersions::new).add((NodePackagesSourceVersions)packages));
        this.versions.forEach((source, packages) -> mergedVersions.computeIfAbsent((NodePackagesVersionSource)source, NodePackagesSourceVersions::new).add((NodePackagesSourceVersions)packages));
        return new NodePackagesVersions(mergedVersions);
    }

    public static class NpmPackagesVersionsBuilder {
        private final Map<NodePackagesVersionSource, NodePackagesSourceVersions> versions = new ConcurrentHashMap<NodePackagesVersionSource, NodePackagesSourceVersions>();

        public NpmPackagesVersionsBuilder put(NodePackagesVersionSource source, Collection<NodePackage> packages) {
            this.versions.computeIfAbsent(source, key -> new NodePackagesSourceVersions(source)).add(packages);
            return this;
        }

        public NodePackagesVersions build() {
            return new NodePackagesVersions(this);
        }
    }

    private static final class NodePackagesSourceVersions {
        private final NodePackagesVersionSource source;
        private final Map<NodePackageName, NodePackageVersion> versions = new ConcurrentHashMap<NodePackageName, NodePackageVersion>();

        private NodePackagesSourceVersions(NodePackagesVersionSource source) {
            Assert.notNull("source", source);
            this.source = source;
        }

        private void add(NodePackagesSourceVersions packages) {
            this.versions.putAll(packages.versions);
        }

        private void add(Collection<NodePackage> packages) {
            Assert.field("packages", packages).notNull().noNullElement();
            this.versions.putAll(packages.stream().collect(Collectors.toMap(NodePackage::name, NodePackage::version)));
        }

        private NodePackageVersion get(NodePackageName packageName) {
            return Optional.ofNullable(this.versions.get(packageName)).orElseThrow(() -> new UnknownNodePackageException(packageName, this.source));
        }
    }
}

