/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import tech.jhipster.lite.module.domain.startupcommand.DockerComposeFile;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public class DockerComposeFileHandler {
    private static final String DASH = "-";
    private static final String LINE_BREAK = System.lineSeparator();
    private static final String SPACER = " ";
    private final Path file;

    public DockerComposeFileHandler(Path file) {
        Assert.notNull("file", file);
        this.file = file;
    }

    public void append(DockerComposeFile dockerComposeFile) {
        Assert.notNull("dockerComposeFile", dockerComposeFile);
        this.updateDockerComposeFile(dockerComposeFile);
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Hard to cover IOException")
    private void updateDockerComposeFile(DockerComposeFile dockerComposeFile) {
        try {
            String properties = this.buildDockerComposeFile(dockerComposeFile);
            Files.writeString(this.file, (CharSequence)properties, new OpenOption[0]);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error updating root compose file: " + e.getMessage(), e);
        }
    }

    private String buildDockerComposeFile(DockerComposeFile dockerComposeFile) throws IOException {
        String currentProperties = this.readOrInitDockerComposeFile();
        int propertyIndex = currentProperties.indexOf(this.dockerComposeLine(dockerComposeFile));
        if (propertyIndex != -1) {
            return currentProperties;
        }
        return this.addNewDockerComposeFile(dockerComposeFile, currentProperties);
    }

    private String addNewDockerComposeFile(DockerComposeFile compose, String currentRootCompose) {
        return currentRootCompose + this.dockerComposeLine(compose) + LINE_BREAK;
    }

    private String dockerComposeLine(DockerComposeFile compose) {
        return SPACER.repeat(2) + "- " + compose.path();
    }

    private String readOrInitDockerComposeFile() throws IOException {
        if (Files.notExists(this.file, new LinkOption[0])) {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            Files.createFile(this.file, new FileAttribute[0]);
            return "include:" + LINE_BREAK;
        }
        return Files.readString(this.file);
    }
}

