/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Service
public class FileSystemProjectFiles
implements ProjectFiles {
    private static final String SLASH = "/";

    @Override
    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    public String readString(String path) {
        String string;
        block8: {
            Assert.notBlank("path", path);
            InputStream input = this.getInputStream(path);
            try {
                this.assertFileExist(path, input);
                string = FileSystemProjectFiles.toString(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw GeneratorException.technicalError("Error closing " + path + ": " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return string;
    }

    private InputStream getInputStream(String path) {
        return FileSystemProjectFiles.class.getResourceAsStream(path.replace("\\", SLASH));
    }

    private void assertFileExist(String path, InputStream input) {
        if (input == null) {
            throw GeneratorException.technicalError("Can't find file: " + path);
        }
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private static String toString(InputStream input) {
        try {
            return IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error reading file: " + e.getMessage(), e);
        }
    }

    @Override
    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    public byte[] readBytes(String path) {
        byte[] byArray;
        block8: {
            Assert.notBlank("path", path);
            InputStream input = this.getInputStream(path);
            try {
                this.assertFileExist(path, input);
                byArray = FileSystemProjectFiles.toByteArray(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw GeneratorException.technicalError("Error closing " + path + ": " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return byArray;
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private static byte[] toByteArray(InputStream input) {
        try {
            return IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error reading file: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> findRecursivelyInPath(String rootFolder) {
        Assert.notBlank("rootFolder", rootFolder);
        Path rootPath = this.rootPathFrom(rootFolder);
        this.assertIsDirectory(rootPath);
        return FileSystemProjectFiles.buildRelativePath(rootFolder, rootPath);
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private Path rootPathFrom(String resourcePath) {
        URL folderUrl = this.getURL(resourcePath);
        this.assertFolderExist(resourcePath, folderUrl);
        try {
            return Path.of(folderUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw GeneratorException.technicalError("Unable to read folder %s: %s".formatted(resourcePath, e.getMessage()), e);
        }
    }

    private void assertFolderExist(String path, URL url) {
        if (url == null) {
            throw GeneratorException.technicalError("Can't find folder: " + path);
        }
    }

    private void assertIsDirectory(Path rootPath) {
        if (!Files.isDirectory(rootPath, new LinkOption[0])) {
            throw GeneratorException.technicalError("Path %s is not a folder".formatted(rootPath));
        }
    }

    @ExcludeFromGeneratedCodeCoverage(reason="The error handling is an hard to test implementation detail")
    private static List<String> buildRelativePath(String rootFolder, Path rootPath) {
        List<String> list;
        block8: {
            Stream<Path> walkStream = FileSystemProjectFiles.getWalkStream(rootPath);
            try {
                list = walkStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(FileSystemProjectFiles.relativePathFrom(rootFolder, rootPath)).toList();
                if (walkStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walkStream != null) {
                        try {
                            walkStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw GeneratorException.technicalError("Error closing %s: %s".formatted(rootFolder, e.getMessage()), e);
                }
            }
            walkStream.close();
        }
        return list;
    }

    @MustBeClosed
    private static Stream<Path> getWalkStream(Path folder) throws IOException {
        return Files.walk(folder, new FileVisitOption[0]);
    }

    private static Function<Path, String> relativePathFrom(String rootFolder, Path rootPath) {
        return path -> {
            Path relativePath = rootPath.relativize((Path)path);
            String relativePathString = relativePath.toString().replace("\\", SLASH);
            return rootFolder + SLASH + relativePathString;
        };
    }

    private URL getURL(String path) {
        return FileSystemProjectFiles.class.getResource(path.replace("\\", SLASH));
    }
}

