/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.file;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.ValueCode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import tech.jhipster.lite.module.domain.file.TemplateRenderer;
import tech.jhipster.lite.shared.error.domain.GeneratorException;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Component
public final class MustacheTemplateRenderer
implements TemplateRenderer {
    private final MustacheFactory mustacheFactory = new CustomMustacheFactory();

    @Override
    @ExcludeFromGeneratedCodeCoverage(reason="IOException is hard to test")
    public String render(String message, Map<String, ?> context) {
        if (message == null || context == null) {
            return message;
        }
        Mustache mustache = this.mustacheFactory.compile((Reader)new StringReader(message), "template");
        try {
            StringWriter stringWriter = new StringWriter();
            mustache.execute((Writer)stringWriter, context).flush();
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Can't render template: " + e.getMessage(), e);
        }
    }

    private static final class CustomMustacheFactory
    extends DefaultMustacheFactory {
        private CustomMustacheFactory() {
        }

        public MustacheVisitor createMustacheVisitor() {
            return new CustomMustacheVisitor(this);
        }
    }

    private static final class CustomValueCode
    extends ValueCode {
        private CustomValueCode(TemplateContext templateContext, DefaultMustacheFactory defaultMustacheFactory, String variable, boolean encoded) {
            super(templateContext, defaultMustacheFactory, variable, encoded);
        }

        @ExcludeFromGeneratedCodeCoverage(reason="Exception is hard to test")
        public Writer execute(Writer writer, List<Object> scopes) {
            try {
                Object object = this.get(scopes);
                if (object == null) {
                    writer.write("{{ " + this.name + " }}");
                }
                return super.execute(writer, scopes);
            }
            catch (Exception e) {
                throw new MustacheException("Failed to get value for " + this.name, (Throwable)e, this.tc);
            }
        }
    }

    private static final class CustomMustacheVisitor
    extends DefaultMustacheVisitor {
        private CustomMustacheVisitor(DefaultMustacheFactory mustacheFactory) {
            super(mustacheFactory);
        }

        public void value(TemplateContext templateContext, String variable, boolean encoded) {
            this.list.add(new CustomValueCode(templateContext, this.df, variable, encoded));
        }
    }
}

