/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.module.domain.git.GitCommitMessage;
import tech.jhipster.lite.module.domain.git.GitRepository;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.git.GitCommitException;
import tech.jhipster.lite.module.infrastructure.secondary.git.GitInitException;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

@Repository
class JGitGitRepository
implements GitRepository {
    private static final Logger log = LoggerFactory.getLogger(JGitGitRepository.class);

    JGitGitRepository() {
    }

    @Override
    public void init(JHipsterProjectFolder folder) {
        Assert.notNull("folder", folder);
        if (this.isGit(folder)) {
            log.trace("Folder {} is already a git project, not running init", (Object)folder.get());
            return;
        }
        try {
            Git.init().setInitialBranch("main").setDirectory(this.folderFile(folder)).call();
        }
        catch (IllegalStateException | GitAPIException | JGitInternalException e) {
            throw new GitInitException("Error during git init: " + e.getMessage(), e);
        }
    }

    private boolean isGit(JHipsterProjectFolder folder) {
        return this.findGitDirectory(folder).isPresent();
    }

    private Optional<File> findGitDirectory(JHipsterProjectFolder folder) {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        return Optional.ofNullable(((FileRepositoryBuilder)repositoryBuilder.findGitDir(this.folderFile(folder))).getGitDir());
    }

    @Override
    @ExcludeFromGeneratedCodeCoverage(reason="IOException are hard to test")
    public void commitAll(JHipsterProjectFolder folder, GitCommitMessage message) {
        Assert.notNull("folder", folder);
        Assert.notNull("message", message);
        File gitRepository = this.findGitDirectory(folder).orElseThrow(() -> new GitCommitException("Can't commit in non existing git repository"));
        try (Git gitFolder = Git.open((File)gitRepository);){
            gitFolder.add().setUpdate(true).addFilepattern(".").call();
            gitFolder.add().addFilepattern(".").call();
            gitFolder.commit().setSign(Boolean.valueOf(false)).setMessage(message.get()).call();
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new GitCommitException("Can't commit :" + e.getMessage(), e);
        }
    }

    private File folderFile(JHipsterProjectFolder folder) {
        return Path.of(folder.get(), new String[0]).toFile();
    }
}

