/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.nodejs;

import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.module.domain.nodejs.NodePackage;
import tech.jhipster.lite.module.domain.nodejs.NodePackagesVersionSource;
import tech.jhipster.lite.module.domain.nodejs.NodePackagesVersionSourceFactory;
import tech.jhipster.lite.module.domain.nodejs.NodePackagesVersions;
import tech.jhipster.lite.module.infrastructure.secondary.nodejs.NodePackagesVersionsReader;
import tech.jhipster.lite.shared.error.domain.Assert;

public class FileSystemNodePackagesVersionReader
implements NodePackagesVersionsReader {
    private static final Pattern DEV_DEPENDENCIES_PATTERN = Pattern.compile("\"devDependencies\"\\s*:\\s*\\{([^}]*)}", 32);
    private static final Pattern DEPENDENCIES_PATTERN = Pattern.compile("\"dependencies\"\\s*:\\s*\\{([^}]*)}", 32);
    private static final Pattern PACKAGES_PATTERN = Pattern.compile("\"([^\"]+)\"\\s*:\\s*\"([^\"]+)\"", 32);
    private final ProjectFiles projectFiles;
    private final Collection<NodePackagesVersionSource> nodePackagesVersionSources;
    private final String parentInputFolder;

    public FileSystemNodePackagesVersionReader(ProjectFiles projectFiles, Collection<NodePackagesVersionSourceFactory> npmVersionSources, String parentInputFolder) {
        Assert.notNull("projectFiles", projectFiles);
        Assert.notNull("nodePackagesVersionSources", npmVersionSources);
        Assert.notBlank("parentInputFolder", parentInputFolder);
        this.projectFiles = projectFiles;
        this.nodePackagesVersionSources = npmVersionSources.stream().map(NodePackagesVersionSourceFactory::build).toList();
        this.parentInputFolder = parentInputFolder;
    }

    @Override
    public NodePackagesVersions get() {
        NodePackagesVersions.NpmPackagesVersionsBuilder builder = NodePackagesVersions.builder();
        this.nodePackagesVersionSources.forEach(source -> builder.put((NodePackagesVersionSource)source, this.sourcePackages((NodePackagesVersionSource)source)));
        return builder.build();
    }

    private Collection<NodePackage> sourcePackages(NodePackagesVersionSource source) {
        String sourceFile = this.readVersionsFile(source);
        return Stream.concat(this.packagesIn(sourceFile, DEV_DEPENDENCIES_PATTERN), this.packagesIn(sourceFile, DEPENDENCIES_PATTERN)).toList();
    }

    private Stream<NodePackage> packagesIn(String source, Pattern pattern) {
        Matcher dependenciesMatcher = pattern.matcher(source);
        if (dependenciesMatcher.find()) {
            return this.readPackages(dependenciesMatcher.group(1));
        }
        return Stream.of(new NodePackage[0]);
    }

    private Stream<NodePackage> readPackages(String content) {
        return PACKAGES_PATTERN.matcher(content).results().map(result -> new NodePackage(result.group(1), result.group(2)));
    }

    private String readVersionsFile(NodePackagesVersionSource source) {
        return this.projectFiles.readString(this.parentInputFolder + this.sourceFolder(source) + "/package.json");
    }

    private String sourceFolder(NodePackagesVersionSource source) {
        return source.name().toLowerCase(Locale.ROOT);
    }
}

