/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.memoizer.domain;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class Memoizers {
    private Memoizers() {
    }

    public static <Result> Supplier<Result> of(Supplier<Result> supplier) {
        Assert.notNull("supplier", supplier);
        return () -> Memoizers.of(arg_0 -> Memoizers.lambda$of$0((Supplier)supplier, arg_0)).apply(null);
    }

    public static <Input, Result> Function<Input, Result> of(Function<Input, Result> function) {
        Assert.notNull("function", function);
        return new MemoizedFunction<Input, Result>(function);
    }

    private static /* synthetic */ Object lambda$of$0(Supplier supplier, Object __) {
        return supplier.get();
    }

    private static final class MemoizedFunction<Input, Result>
    implements Function<Input, Result> {
        private final Function<Input, Result> function;
        private final Map<MemoizedInput<Input>, MemoizedResult<Result>> results = new ConcurrentHashMap<MemoizedInput<Input>, MemoizedResult<Result>>();

        private MemoizedFunction(Function<Input, Result> function) {
            this.function = function;
        }

        @Override
        public Result apply(Input input) {
            return this.results.computeIfAbsent(new MemoizedInput<Input>(input), this::toMemoizedResult).result();
        }

        private MemoizedResult<Result> toMemoizedResult(MemoizedInput<Input> input) {
            return new MemoizedResult<Result>(this.function.apply(input.input()));
        }

        private record MemoizedInput<Input>(Input input) {
        }

        private record MemoizedResult<Result>(Result result) {
        }
    }
}

