/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.slug.domain;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleRank;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleSlugFactory;

public enum JHLiteModuleSlug implements JHipsterModuleSlugFactory
{
    ANGULAR_CORE("angular-core", JHipsterModuleRank.RANK_A),
    ANGULAR_HEALTH("angular-health", JHipsterModuleRank.RANK_C),
    ANGULAR_JWT("angular-jwt", JHipsterModuleRank.RANK_C),
    ANGULAR_OAUTH_2("angular-oauth2-keycloak", JHipsterModuleRank.RANK_C),
    APPLICATION_SERVICE_HEXAGONAL_ARCHITECTURE_DOCUMENTATION("application-service-hexagonal-architecture-documentation", JHipsterModuleRank.RANK_A),
    APPROVAL_TESTS("approval-tests", JHipsterModuleRank.RANK_B),
    CAFFEINE_CACHE("caffeine-cache", JHipsterModuleRank.RANK_A),
    CASSANDRA("cassandra", JHipsterModuleRank.RANK_C),
    CASSANDRA_MIGRATION("cassandra-migration", JHipsterModuleRank.RANK_C),
    CHECKSTYLE("checkstyle", JHipsterModuleRank.RANK_A),
    CONSUL("consul", JHipsterModuleRank.RANK_B),
    CUSTOM_JHLITE("custom-jhlite", JHipsterModuleRank.RANK_A),
    CYPRESS_COMPONENT_TESTS("cypress-component-tests", JHipsterModuleRank.RANK_B),
    CYPRESS_E2E("cypress-e2e", JHipsterModuleRank.RANK_B),
    DATASOURCE_MARIADB("datasource-mariadb", JHipsterModuleRank.RANK_B),
    DATASOURCE_MSSQL("datasource-mssql", JHipsterModuleRank.RANK_C),
    DATASOURCE_MYSQL("datasource-mysql", JHipsterModuleRank.RANK_A),
    DATASOURCE_POSTGRESQL("datasource-postgresql", JHipsterModuleRank.RANK_S),
    DOCKERFILE_MAVEN("dockerfile-maven", JHipsterModuleRank.RANK_C),
    DOCKERFILE_GRADLE("dockerfile-gradle", JHipsterModuleRank.RANK_C),
    EHCACHE_JAVA_CONFIG("ehcache-java-config", JHipsterModuleRank.RANK_B),
    EHCACHE_XML_CONFIG("ehcache-xml-config", JHipsterModuleRank.RANK_C),
    EUREKA_CLIENT("eureka-client", JHipsterModuleRank.RANK_C),
    FLYWAY("flyway", JHipsterModuleRank.RANK_C),
    FLYWAY_MARIADB("flyway-mariadb", JHipsterModuleRank.RANK_C),
    FLYWAY_MSSQL("flyway-mssql", JHipsterModuleRank.RANK_C),
    FLYWAY_MYSQL("flyway-mysql", JHipsterModuleRank.RANK_C),
    FLYWAY_POSTGRESQL("flyway-postgresql", JHipsterModuleRank.RANK_C),
    FRONTEND_MAVEN_PLUGIN("frontend-maven-plugin", JHipsterModuleRank.RANK_S),
    FRONTEND_MAVEN_PLUGIN_CACHE("frontend-maven-plugin-cache", JHipsterModuleRank.RANK_B),
    FRONTEND_MAVEN_PLUGIN_MERGE_COVERAGE("frontend-maven-plugin-merge-coverage", JHipsterModuleRank.RANK_B),
    FRONT_HEXAGONAL_ARCHITECTURE("front-hexagonal-architecture", JHipsterModuleRank.RANK_C),
    NODE_GRADLE_PLUGIN("node-gradle-plugin", JHipsterModuleRank.RANK_C),
    GATEWAY("gateway", JHipsterModuleRank.RANK_C),
    GIT_INFORMATION("git-information", JHipsterModuleRank.RANK_B),
    GITHUB_ACTIONS_MAVEN("github-actions-maven", JHipsterModuleRank.RANK_B),
    GITHUB_ACTIONS_GRADLE("github-actions-gradle", JHipsterModuleRank.RANK_B),
    GITHUB_CODESPACES("github-codespaces", JHipsterModuleRank.RANK_D),
    GITLAB_CI_MAVEN("gitlab-ci-maven", JHipsterModuleRank.RANK_B),
    GITLAB_CI_GRADLE("gitlab-ci-gradle", JHipsterModuleRank.RANK_B),
    GITPOD("gitpod", JHipsterModuleRank.RANK_D),
    GRADLE_JAVA("gradle-java", JHipsterModuleRank.RANK_C),
    GRADLE_WRAPPER("gradle-wrapper", JHipsterModuleRank.RANK_C),
    HIBERNATE_2ND_LEVEL_CACHE("hibernate-2nd-level-cache", JHipsterModuleRank.RANK_B),
    INFINITEST_FILTERS("infinitest-filters", JHipsterModuleRank.RANK_A),
    INIT("init", JHipsterModuleRank.RANK_S),
    INTERNATIONALIZED_ERRORS("internationalized-errors", JHipsterModuleRank.RANK_B),
    JACOCO("jacoco", JHipsterModuleRank.RANK_A),
    JACOCO_WITH_MIN_COVERAGE_CHECK("jacoco-with-min-coverage-check", JHipsterModuleRank.RANK_A),
    JAVA_ARCHUNIT("java-archunit", JHipsterModuleRank.RANK_A),
    JAVA_BASE("java-base", JHipsterModuleRank.RANK_S),
    JAVA_ENUMS("java-enums", JHipsterModuleRank.RANK_B),
    JAVA_MEMOIZERS("java-memoizers", JHipsterModuleRank.RANK_B),
    JIB("jib", JHipsterModuleRank.RANK_B),
    JMOLECULES("jmolecules", JHipsterModuleRank.RANK_B),
    JOOQ_MARIADB("jooq-mariadb", JHipsterModuleRank.RANK_C),
    JOOQ_MSSQL("jooq-mssql", JHipsterModuleRank.RANK_C),
    JOOQ_MYSQL("jooq-mysql", JHipsterModuleRank.RANK_C),
    JOOQ_POSTGRESQL("jooq-postgresql", JHipsterModuleRank.RANK_C),
    JPA_PAGINATION("jpa-pagination", JHipsterModuleRank.RANK_A),
    JPA_MARIADB("jpa-mariadb", JHipsterModuleRank.RANK_B),
    JPA_MSSQL("jpa-mssql", JHipsterModuleRank.RANK_C),
    JPA_MYSQL("jpa-mysql", JHipsterModuleRank.RANK_A),
    JPA_POSTGRESQL("jpa-postgresql", JHipsterModuleRank.RANK_S),
    JQASSISTANT("jqassistant", JHipsterModuleRank.RANK_B),
    JQASSISTANT_JMOLECULES("jqassistant-jmolecules", JHipsterModuleRank.RANK_B),
    JQASSISTANT_SPRING("jqassistant-spring", JHipsterModuleRank.RANK_B),
    JQWIK("jqwik", JHipsterModuleRank.RANK_C),
    KIPE_AUTHORIZATION("kipe-authorization", JHipsterModuleRank.RANK_B),
    KIPE_EXPRESSION("kipe-expression", JHipsterModuleRank.RANK_B),
    LANGCHAIN4J("langchain4j", JHipsterModuleRank.RANK_C),
    LICENSE_APACHE("license-apache", JHipsterModuleRank.RANK_B),
    LICENSE_MIT("license-mit", JHipsterModuleRank.RANK_B),
    LIQUIBASE("liquibase", JHipsterModuleRank.RANK_S),
    LIQUIBASE_ASYNC("liquibase-async", JHipsterModuleRank.RANK_B),
    LIQUIBASE_LINTER("liquibase-linter", JHipsterModuleRank.RANK_B),
    LOGSTASH("logstash", JHipsterModuleRank.RANK_B),
    LOGS_SPY("logs-spy", JHipsterModuleRank.RANK_S),
    CYPRESS_MERGE_COVERAGE("cypress-merge-coverage", JHipsterModuleRank.RANK_B),
    MAVEN_JAVA("maven-java", JHipsterModuleRank.RANK_S),
    MAVEN_WRAPPER("maven-wrapper", JHipsterModuleRank.RANK_S),
    MODERNIZER("modernizer", JHipsterModuleRank.RANK_C),
    MONGOCK("mongock", JHipsterModuleRank.RANK_C),
    MONGODB("mongodb", JHipsterModuleRank.RANK_C),
    NEO4J("neo4j", JHipsterModuleRank.RANK_C),
    NEO4J_MIGRATIONS("neo4j-migrations", JHipsterModuleRank.RANK_C),
    OPENAPI_CONTRACT("openapi-contract", JHipsterModuleRank.RANK_B),
    OPENAPI_BACKWARDS_COMPATIBILITY_CHECK("openapi-backwards-compatibility-check", JHipsterModuleRank.RANK_B),
    OPTIONAL_TYPESCRIPT("optional-typescript", JHipsterModuleRank.RANK_B),
    PAGINATION_DOMAIN("pagination-domain", JHipsterModuleRank.RANK_A),
    PLAYWRIGHT_COMPONENT_TESTS("playwright-component-tests", JHipsterModuleRank.RANK_C),
    PLAYWRIGHT_E2E("playwright-e2e", JHipsterModuleRank.RANK_C),
    PRETTIER("prettier", JHipsterModuleRank.RANK_S),
    PROTOBUF("protobuf", JHipsterModuleRank.RANK_A),
    PROTOBUF_BACKWARDS_COMPATIBILITY_CHECK("protobuf-backwards-compatibility-check", JHipsterModuleRank.RANK_A),
    REACT_CORE("react-core", JHipsterModuleRank.RANK_B),
    REACT_I18N("react-i18next", JHipsterModuleRank.RANK_C),
    REACT_JWT("react-jwt", JHipsterModuleRank.RANK_C),
    REDIS("redis", JHipsterModuleRank.RANK_C),
    RENOVATE("renovate", JHipsterModuleRank.RANK_B),
    REST_PAGINATION("rest-pagination", JHipsterModuleRank.RANK_A),
    SAMPLE_CASSANDRA_PERSISTENCE("sample-cassandra-persistence", JHipsterModuleRank.RANK_D),
    SAMPLE_FEATURE("sample-feature", JHipsterModuleRank.RANK_D),
    SAMPLE_JPA_PERSISTENCE("sample-jpa-persistence", JHipsterModuleRank.RANK_D),
    SAMPLE_LIQUIBASE_CHANGELOG("sample-liquibase-changelog", JHipsterModuleRank.RANK_D),
    SAMPLE_MONGODB_PERSISTENCE("sample-mongodb-persistence", JHipsterModuleRank.RANK_D),
    SAMPLE_NOT_POSTGRESQL_FLYWAY_CHANGELOG("sample-not-postgresql-flyway-changelog", JHipsterModuleRank.RANK_D),
    SAMPLE_POSTGRESQL_FLYWAY_CHANGELOG("sample-postgresql-flyway-changelog", JHipsterModuleRank.RANK_D),
    SONARQUBE_JAVA_BACKEND("sonarqube-java-backend", JHipsterModuleRank.RANK_A),
    SONARQUBE_JAVA_BACKEND_AND_FRONTEND("sonarqube-java-backend-and-frontend", JHipsterModuleRank.RANK_A),
    SONARQUBE_TYPESCRIPT("sonarqube-typescript", JHipsterModuleRank.RANK_B),
    SPRING_BOOT("spring-boot", JHipsterModuleRank.RANK_S),
    SPRING_BOOT_ACTUATOR("spring-boot-actuator", JHipsterModuleRank.RANK_S),
    SPRING_BOOT_ASYNC("spring-boot-async", JHipsterModuleRank.RANK_A),
    SPRING_BOOT_CACHE("spring-boot-cache", JHipsterModuleRank.RANK_A),
    SPRING_BOOT_CUCUMBER_MVC("spring-boot-cucumber-mvc", JHipsterModuleRank.RANK_A),
    SPRING_BOOT_CUCUMBER_WEBFLUX("spring-boot-cucumber-webflux", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_CUCUMBER_JPA_RESET("spring-boot-cucumber-jpa-reset", JHipsterModuleRank.RANK_A),
    SPRING_BOOT_CUCUMBER_JWT_AUTHENTICATION("spring-boot-cucumber-jwt-authentication", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_CUCUMBER_OAUTH_2_AUTHENTICATION("spring-boot-cucumber-oauth2-authentication", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_DEVTOOLS("spring-boot-devtools", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_LOCAL_PROFILE("spring-boot-local-profile", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_DOCKER_COMPOSE("spring-boot-docker-compose", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_JWT("spring-boot-jwt", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_JWT_BASIC_AUTH("spring-boot-jwt-basic-auth", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_KAFKA("spring-boot-kafka", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_KAFKA_AKHQ("spring-boot-kafka-akhq", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_KAFKA_SAMPLE_PRODUCER_CONSUMER("spring-boot-kafka-sample-producer-consumer", JHipsterModuleRank.RANK_D),
    SPRING_BOOT_OAUTH_2("spring-boot-oauth2", JHipsterModuleRank.RANK_A),
    SPRING_BOOT_OAUTH_2_ACCOUNT("spring-boot-oauth2-account", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_OAUTH_2_AUTH_0("spring-boot-oauth2-auth0", JHipsterModuleRank.RANK_D),
    SPRING_BOOT_OAUTH_2_OKTA("spring-boot-oauth2-okta", JHipsterModuleRank.RANK_D),
    SPRING_BOOT_PULSAR("spring-boot-pulsar", JHipsterModuleRank.RANK_D),
    SPRING_BOOT_MVC_EMPTY("spring-boot-mvc-empty", JHipsterModuleRank.RANK_S),
    SPRING_BOOT_THYMELEAF("spring-boot-thymeleaf", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_LANGCHAIN4J_SAMPLE("spring-boot-langchain4j-sample", JHipsterModuleRank.RANK_D),
    SPRING_BOOT_TOMCAT("spring-boot-tomcat", JHipsterModuleRank.RANK_S),
    SPRING_BOOT_UNDERTOW("spring-boot-undertow", JHipsterModuleRank.RANK_B),
    SPRING_BOOT_WEBFLUX_EMPTY("spring-boot-webflux-empty", JHipsterModuleRank.RANK_C),
    SPRING_BOOT_WEBFLUX_NETTY("spring-boot-webflux-netty", JHipsterModuleRank.RANK_C),
    SPRING_CLOUD("spring-cloud", JHipsterModuleRank.RANK_B),
    SPRINGDOC_JWT("springdoc-jwt", JHipsterModuleRank.RANK_C),
    SPRINGDOC_MVC_OPENAPI("springdoc-mvc-openapi", JHipsterModuleRank.RANK_S),
    SPRINGDOC_OAUTH_2("springdoc-oauth2", JHipsterModuleRank.RANK_B),
    SPRINGDOC_OAUTH_2_AUTH_0("springdoc-oauth2-auth0", JHipsterModuleRank.RANK_D),
    SPRINGDOC_OAUTH_2_OKTA("springdoc-oauth2-okta", JHipsterModuleRank.RANK_D),
    SPRINGDOC_WEBFLUX_OPENAPI("springdoc-webflux-openapi", JHipsterModuleRank.RANK_C),
    THYMELEAF_TEMPLATE("thymeleaf-template", JHipsterModuleRank.RANK_C),
    THYMELEAF_TEMPLATE_HTMX_WEBJAR("thymeleaf-template-htmx-webjars", JHipsterModuleRank.RANK_C),
    THYMELEAF_TEMPLATE_ALPINEJS_WEBJAR("thymeleaf-template-alpinejs-webjars", JHipsterModuleRank.RANK_C),
    THYMELEAF_TEMPLATE_TAILWINDCSS("thymeleaf-template-tailwindcss", JHipsterModuleRank.RANK_C),
    TIKUI("tikui", JHipsterModuleRank.RANK_B),
    TS_LOADER("ts-loader", JHipsterModuleRank.RANK_C),
    TS_PAGINATION_DOMAIN("ts-pagination-domain", JHipsterModuleRank.RANK_A),
    TS_REST_PAGINATION("ts-rest-pagination", JHipsterModuleRank.RANK_A),
    WEBJARS_LOCATOR("webjars-locator", JHipsterModuleRank.RANK_C),
    HTMX_WEBJARS("htmx-webjars", JHipsterModuleRank.RANK_C),
    ALPINE_JS_WEBJARS("alpinejs-webjars", JHipsterModuleRank.RANK_C),
    SVELTE_CORE("svelte-core", JHipsterModuleRank.RANK_D),
    TYPESCRIPT("typescript", JHipsterModuleRank.RANK_S),
    VUE_CORE("vue-core", JHipsterModuleRank.RANK_A),
    VUE_I18N("vue-i18next", JHipsterModuleRank.RANK_C),
    VUE_JWT("vue-jwt", JHipsterModuleRank.RANK_C),
    VUE_OAUTH2_KEYCLOAK("vue-oauth2-keycloak", JHipsterModuleRank.RANK_C),
    VUE_PINIA("vue-pinia", JHipsterModuleRank.RANK_C),
    VUE_ROUTER("vue-router", JHipsterModuleRank.RANK_C);

    private static final Map<String, JHLiteModuleSlug> moduleSlugMap;
    private final String slug;
    private final JHipsterModuleRank rank;

    private JHLiteModuleSlug(String slug, JHipsterModuleRank rank) {
        this.slug = slug;
        this.rank = rank;
    }

    @Override
    public String get() {
        return this.slug;
    }

    @Override
    public JHipsterModuleRank rank() {
        return this.rank;
    }

    public static Optional<JHipsterModuleRank> getRank(String slug) {
        return JHLiteModuleSlug.fromString(slug).map(JHLiteModuleSlug::rank);
    }

    public static Optional<JHLiteModuleSlug> fromString(String slug) {
        return Optional.ofNullable(moduleSlugMap.get(slug));
    }

    static {
        moduleSlugMap = Stream.of(JHLiteModuleSlug.values()).collect(Collectors.toMap(JHLiteModuleSlug::get, Function.identity()));
    }
}

