/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.prettier.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class PrettierModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("prettier");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(".");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).put("endOfLine", this.endOfLine(properties)).and().files().batch(SOURCE, DESTINATION).addFile(".lintstagedrc.cjs").addFile(".prettierignore").addTemplate(".prettierrc").and().addExecutable(SOURCE.append(".husky").file("pre-commit"), DESTINATION.append(".husky/pre-commit")).and().packageJson().addDevDependency(JHipsterModule.packageName("@prettier/plugin-xml"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("husky"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("lint-staged"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-gherkin"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-java"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-packagejson"), VersionSource.COMMON).addScript(JHipsterModule.scriptKey("prepare"), JHipsterModule.scriptCommand("husky")).addScript(JHipsterModule.scriptKey("prettier:check"), JHipsterModule.scriptCommand("prettier --check '{,src/**/}*.{md,json,yml,html,js,ts,tsx,css,scss,vue,java,xml,feature}'")).addScript(JHipsterModule.scriptKey("prettier:format"), JHipsterModule.scriptCommand("prettier --write '{,src/**/}*.{md,json,yml,html,js,ts,tsx,css,scss,vue,java,xml,feature}'")).and().build();
    }

    private String endOfLine(JHipsterModuleProperties properties) {
        return properties.getOrDefaultString("endOfLine", "lf");
    }
}

