/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.apidocumentation.springdocauth0.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringDocAuth0ModuleFactory {
    private static final SpringProfile AUTH0_SPRING_PROFILE = new SpringProfile("auth0");
    private static final String AUTH0_CLIENT_ID_PROPERTY = "auth0ClientId";
    private static final String AUTH0_DOMAIN_PROPERTY = "auth0Domain";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).springMainProperties(AUTH0_SPRING_PROFILE).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.client-id"), SpringDocAuth0ModuleFactory.clientId(properties)).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.realm"), JHipsterModule.propertyValue("jhipster")).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.scopes"), JHipsterModule.propertyValue("openid", "profile", "email")).set(JHipsterModule.propertyKey("springdoc.oauth2.authorization-url"), SpringDocAuth0ModuleFactory.authorizationUrl(properties)).and().build();
    }

    private static PropertyValue clientId(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue(properties.getString(AUTH0_CLIENT_ID_PROPERTY));
    }

    private static PropertyValue authorizationUrl(JHipsterModuleProperties properties) {
        String auth0Domain = properties.getString(AUTH0_DOMAIN_PROPERTY);
        return JHipsterModule.propertyValue("https://%s/authorize?audience=https://%s/api/v2/".formatted(auth0Domain, auth0Domain));
    }
}

