/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.apidocumentation.springdocokta.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringDocOktaModuleFactory {
    private static final SpringProfile OKTA_SPRING_PROFILE = new SpringProfile("okta");
    private static final String OKTA_CLIENT_ID_PROPERTY = "oktaClientId";
    private static final String OKTA_DOMAIN_PROPERTY = "oktaDomain";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).springMainProperties(OKTA_SPRING_PROFILE).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.client-id"), SpringDocOktaModuleFactory.clientId(properties)).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.realm"), JHipsterModule.propertyValue("jhipster")).set(JHipsterModule.propertyKey("springdoc.swagger-ui.oauth.scopes"), JHipsterModule.propertyValue("openid", "profile", "email")).set(JHipsterModule.propertyKey("springdoc.oauth2.authorization-url"), SpringDocOktaModuleFactory.authorizationUrl(properties)).and().build();
    }

    private static PropertyValue clientId(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue(properties.getString(OKTA_CLIENT_ID_PROPERTY));
    }

    private static PropertyValue authorizationUrl(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("https://" + properties.getString(OKTA_DOMAIN_PROPERTY) + "/oauth2/default/v1/authorize?nonce=\"jhipster\"");
    }
}

