/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.cassandra.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CassandraModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/database/cassandra");
    private static final String CASSANDRA_SECONDARY = "wire/cassandra/infrastructure/secondary";
    private static final String DC = "datacenter1";
    private final DockerImages dockerImages;

    public CassandraModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        String packageName = properties.basePackage().get() + ".";
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-data-cassandra")).addDependency(this.testContainerDependency()).and().documentation(JHipsterModule.documentationTitle("Cassandra"), SOURCE.file("cassandra.md")).startupCommands().dockerCompose("src/main/docker/cassandra.yml").and().context().put("cassandraDockerImage", this.dockerImages.get("cassandra").fullName()).put("DC", DC).and().files().batch(SOURCE, JHipsterModule.toSrcMainJava().append(packagePath).append(CASSANDRA_SECONDARY)).addTemplate("CassandraDatabaseConfiguration.java").addTemplate("CassandraJSR310DateConverters.java").and().add(SOURCE.template("CassandraJSR310DateConvertersTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(CASSANDRA_SECONDARY).append("CassandraJSR310DateConvertersTest.java")).add(SOURCE.template("cassandra.yml"), JHipsterModule.toSrcMainDocker().append("cassandra.yml")).add(SOURCE.template("TestCassandraManager.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestCassandraManager.java")).add(SOURCE.template("CassandraKeyspaceIT.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("CassandraKeyspaceIT.java")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.cassandra.contact-points"), JHipsterModule.propertyValue("127.0.0.1")).set(JHipsterModule.propertyKey("#spring.cassandra.keyspace-name"), JHipsterModule.propertyValue("yourKeyspace")).set(JHipsterModule.propertyKey("spring.cassandra.port"), JHipsterModule.propertyValue(9042)).set(JHipsterModule.propertyKey("spring.cassandra.local-datacenter"), JHipsterModule.propertyValue(DC)).set(JHipsterModule.propertyKey("spring.cassandra.schema-action"), JHipsterModule.propertyValue("none")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.cassandra.port"), JHipsterModule.propertyValue("${TEST_CASSANDRA_PORT}")).set(JHipsterModule.propertyKey("spring.cassandra.contact-points"), JHipsterModule.propertyValue("${TEST_CASSANDRA_CONTACT_POINT}")).set(JHipsterModule.propertyKey("spring.cassandra.local-datacenter"), JHipsterModule.propertyValue("${TEST_CASSANDRA_DC}")).set(JHipsterModule.propertyKey("spring.cassandra.keyspace-name"), JHipsterModule.propertyValue("${TEST_CASSANDRA_KEYSPACE}")).and().springTestFactories().append(JHipsterModule.propertyKey("org.springframework.context.ApplicationListener"), JHipsterModule.propertyValue(packageName + "TestCassandraManager")).and().springMainLogger("com.datastax", LogLevel.WARN).springTestLogger("com.datastax", LogLevel.WARN).springTestLogger("org.testcontainers", LogLevel.WARN).build();
    }

    private JavaDependency testContainerDependency() {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId("cassandra").versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }
}

