/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.auth0.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class OAuth2Auth0ModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/security/oauth2/auth0");
    private static final SpringProfile AUTH0_SPRING_PROFILE = new SpringProfile("auth0");
    private static final String CLIENT_ID_PROPERTY = "auth0ClientId";
    private static final String AUTH0_DOMAIN_PROPERTY = "auth0Domain";
    private static final String AUTH0_SHELL_SCRIPT = "auth0.sh";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Auth0"), SOURCE.template("documentation/auth0.md.mustache")).gitIgnore().comment("OAuth 2.0").pattern(AUTH0_SHELL_SCRIPT).and().files().add(SOURCE.file(AUTH0_SHELL_SCRIPT), JHipsterModule.to(AUTH0_SHELL_SCRIPT)).and().springMainProperties(AUTH0_SPRING_PROFILE).set(JHipsterModule.propertyKey("application.security.oauth2.audience"), OAuth2Auth0ModuleFactory.audience(properties)).set(JHipsterModule.propertyKey("spring.security.oauth2.client.provider.oidc.issuer-uri"), OAuth2Auth0ModuleFactory.issuerUri(properties)).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.client-id"), OAuth2Auth0ModuleFactory.clientId(properties)).and().build();
    }

    private static PropertyValue audience(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("application.security.oauth2.audience=account", "api://default", "https://" + properties.getString(AUTH0_DOMAIN_PROPERTY) + "/api/v2/");
    }

    private static PropertyValue issuerUri(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue("https://" + properties.getString(AUTH0_DOMAIN_PROPERTY) + "/");
    }

    private static PropertyValue clientId(JHipsterModuleProperties properties) {
        return JHipsterModule.propertyValue(properties.getString(CLIENT_ID_PROPERTY));
    }
}

