/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.okta.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.okta.application.OAuth2OktaSecurityApplicationService;
import tech.jhipster.lite.generator.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.generator.slug.domain.JHLiteModuleSlug;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertyDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;

@Configuration
class OAuth2OktaModuleConfiguration {
    private static final String AUTHENTICATION = "authentication";

    OAuth2OktaModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource oAuth2OktaModule(OAuth2OktaSecurityApplicationService oAuth2) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SPRING_BOOT_OAUTH_2_OKTA).propertiesDefinition(this.initPropertiesDefinition()).apiDoc("Spring Boot - MVC - Security", "Add a Spring Security: OAuth 2.0 / OIDC Authentication / Okta Provider (stateful, works with Keycloak and Okta)").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.OAUTH_PROVIDER).addDependency(JHLiteModuleSlug.SPRING_BOOT_OAUTH_2).build()).tags("server", "spring", "spring-boot", AUTHENTICATION, "okta").factory(oAuth2::buildOAuth2OktaModule);
    }

    private JHipsterModulePropertiesDefinition initPropertiesDefinition() {
        return JHipsterModulePropertiesDefinition.builder().addProjectBaseName().addProjectName().add(OAuth2OktaModuleConfiguration.oktaDomain()).add(OAuth2OktaModuleConfiguration.oktaClientId()).addIndentation().addSpringConfigurationFormat().build();
    }

    public static JHipsterModulePropertyDefinition oktaDomain() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("oktaDomain").description("Okta domain").defaultValue("dev-123456.okta.com").order(600).build();
    }

    public static JHipsterModulePropertyDefinition oktaClientId() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("oktaClientId").description("Okta Client ID for OIDC application").defaultValue("0oab8eb55Kb9jdMIr5d6").order(700).build();
    }
}

