/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.thymeleaf.template.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.generator.client.common.domain.ClientsModulesFactory;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class ThymeleafTemplateModuleFactory {
    private static final String PROPERTIES = "properties";
    private static final String TEMPLATES = "templates";
    private static final String TEMPLATES_LAYOUT = "templates/layout";
    private static final String STATIC_CSS = "static/css";
    private static final String STATIC_IMAGES = "static/images";
    private static final String MAIN_HTML = "main.html";
    private static final String POSTCSS_CONFIG_JS = "postcss.config.js";
    private static final String TAILWIND_CONFIG_JS = "tailwind.config.js";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/thymeleaf/template");
    private static final JHipsterSource DOCUMENTATION_SOURCE = SOURCE.append("documentation");
    private static final JHipsterSource RESOURCES_SOURCE = SOURCE.append("src/main/resources");
    private static final JHipsterProjectFilePath MAIN_RESOURCES_PATH = JHipsterModule.path("src/main/resources");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(MAIN_RESOURCES_PATH.get());
    private static final JHipsterDestination ROOT_DESTINATION = JHipsterModule.to(".");
    private static final String MAIN_SCRIPT_NEEDLE = "<!-- jhipster-needle-thymeleaf-main-script -->";
    private static final String THYMELEAF_POSTCSS_PLUGINS_NEEDLE = "// jhipster-needle-thymeleaf-postcss-plugins";
    private static final String THYMELEAF_CSS_NEEDLE = "/* jhipster-needle-thymeleaf-css */";
    private static final Pattern WELCOME_THYMELEAF_MESSAGE_PATTERN = Pattern.compile("<div>Welcome to your Spring Boot with Thymeleaf project!</div>");
    private static final ElementReplacer EXISTING_WELCOME_THYMELEAF_MESSAGE_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> WELCOME_THYMELEAF_MESSAGE_PATTERN.matcher(contentBeforeReplacement).find(), WELCOME_THYMELEAF_MESSAGE_PATTERN);
    private static final String TAILWINDCSS_REQUIRE = "            ,require('tailwindcss')";
    private static final String TAILWINDCSS_SETUP = "/*! @import */\n@tailwind base;\n@tailwind components;\n@tailwind utilities;\n";
    private static final String TAILWINDCSS_WELCOME_THYMELEAF_MESSAGE = "<main class=\"flex flex-col min-h-screen w-full justify-center\">\n  <section\n    class=\"flex flex-col w-full py-16 md:py-24 border-2 border-dashed border-green-500\"\n  >\n    <div\n      class=\"flex flex-col w-full max-w-7xl mx-auto px-4 md:px-8 xl:px-20 gap-8\"\n    >\n      <div class=\"flex justify-center items-center gap-2\">\n        <img\n          class=\"w-36 h-36\"\n          th:src=\"@{/images/ThymeleafLogo.png}\"\n          alt=\"Thymeleaf Logo\"\n        />\n        <h1 class=\"text-6xl font-bold\">Thymeleaf</h1>\n      </div>\n      <div class=\"flex justify-center\">\n        <div class=\"text-lg\">\n          Welcome to your Spring Boot with Thymeleaf project!\n        </div>\n      </div>\n    </div>\n  </section>\n</main>\n";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        return ClientsModulesFactory.clientModuleBuilder(properties).documentation(JHipsterModule.documentationTitle("Thymeleaf"), DOCUMENTATION_SOURCE.template("thymeleaf.md")).packageJson().addDevDependency(JHipsterModule.packageName("@babel/cli"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("autoprefixer"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("browser-sync"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("cssnano"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("mkdirp"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("npm-run-all"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("onchange"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("path-exists-cli"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("postcss"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("postcss-cli"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("recursive-copy-cli"), VersionSource.COMMON).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("npm-run-all --parallel build:*")).addScript(JHipsterModule.scriptKey("build:html"), JHipsterModule.scriptCommand("recursive-copy 'src/main/resources/templates' {{projectBuildDirectory}}/classes/templates -w")).addScript(JHipsterModule.scriptKey("build:css"), JHipsterModule.scriptCommand("mkdirp {{projectBuildDirectory}}/classes/static/css && postcss src/main/resources/static/css/*.css -d {{projectBuildDirectory}}/classes/static/css")).addScript(JHipsterModule.scriptKey("build:js"), JHipsterModule.scriptCommand("path-exists src/main/resources/static/js && (mkdirp {{projectBuildDirectory}}/classes/static/js && babel src/main/resources/static/js/ --out-dir {{projectBuildDirectory}}/classes/static/js/) || echo 'No src/main/resources/static/js directory found.'")).addScript(JHipsterModule.scriptKey("build:svg"), JHipsterModule.scriptCommand("path-exists src/main/resources/static/svg && recursive-copy 'src/main/resources/static/svg' {{projectBuildDirectory}}/classes/static/svg -w -f '**/*.svg' || echo 'No src/main/resources/static/svg directory found.'")).addScript(JHipsterModule.scriptKey("build-prod"), JHipsterModule.scriptCommand("NODE_ENV='production' npm-run-all --parallel build-prod:*")).addScript(JHipsterModule.scriptKey("build-prod:html"), JHipsterModule.scriptCommand("npm run build:html")).addScript(JHipsterModule.scriptKey("build-prod:css"), JHipsterModule.scriptCommand("npm run build:css")).addScript(JHipsterModule.scriptKey("build-prod:js"), JHipsterModule.scriptCommand("path-exists src/main/resources/static/js && (mkdirp {{projectBuildDirectory}}/classes/static/js && babel src/main/resources/static/js/ --minified --out-dir {{projectBuildDirectory}}/classes/static/js/) || echo 'No src/main/resources/static/js directory found.'")).addScript(JHipsterModule.scriptKey("build-prod:svg"), JHipsterModule.scriptCommand("npm run build:svg")).addScript(JHipsterModule.scriptKey("watch"), JHipsterModule.scriptCommand("npm-run-all --parallel watch:*")).addScript(JHipsterModule.scriptKey("watch:html"), JHipsterModule.scriptCommand("onchange 'src/main/resources/templates/**/*.html' -- npm run build:html")).addScript(JHipsterModule.scriptKey("watch:css"), JHipsterModule.scriptCommand("onchange 'src/main/resources/static/css/**/*.css' -- npm run build:css")).addScript(JHipsterModule.scriptKey("watch:js"), JHipsterModule.scriptCommand("onchange 'src/main/resources/static/js/**/*.js' -- npm run build:js")).addScript(JHipsterModule.scriptKey("watch:svg"), JHipsterModule.scriptCommand("onchange 'src/main/resources/static/svg/**/*.svg' -- npm run build:svg")).addScript(JHipsterModule.scriptKey("watch:serve"), JHipsterModule.scriptCommand("browser-sync start --proxy localhost:%s --files '{{projectBuildDirectory}}/classes/templates' '{{projectBuildDirectory}}/classes/static'".formatted(properties.serverPort().get()))).and().files().add(RESOURCES_SOURCE.append(TEMPLATES).template("index.html"), JHipsterModule.toSrcMainResources().append(TEMPLATES).append("index.html")).add(RESOURCES_SOURCE.append(TEMPLATES_LAYOUT).template(MAIN_HTML), JHipsterModule.toSrcMainResources().append(TEMPLATES_LAYOUT).append(MAIN_HTML)).add(RESOURCES_SOURCE.append(STATIC_CSS).template("application.css"), DESTINATION.append(STATIC_CSS).append("application.css")).add(SOURCE.template(POSTCSS_CONFIG_JS), ROOT_DESTINATION.append(POSTCSS_CONFIG_JS)).and().build();
    }

    public JHipsterModule buildTailwindcssModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)ClientsModulesFactory.clientModuleBuilder(properties).packageJson().addDevDependency(JHipsterModule.packageName("tailwindcss"), VersionSource.COMMON).addScript(JHipsterModule.scriptKey("watch:html"), JHipsterModule.scriptCommand("onchange 'src/main/resources/templates/**/*.html' -- npm-run-all --serial build:css build:html")).addScript(JHipsterModule.scriptKey("watch:serve"), JHipsterModule.scriptCommand("browser-sync start --no-inject-changes --proxy localhost:%s --files '{{projectBuildDirectory}}/classes/templates' '{{projectBuildDirectory}}/classes/static'".formatted(properties.serverPort().get()))).and().mandatoryReplacements().in(JHipsterModule.path(POSTCSS_CONFIG_JS)).add(JHipsterModule.lineBeforeText(THYMELEAF_POSTCSS_PLUGINS_NEEDLE), TAILWINDCSS_REQUIRE)).and()).in(JHipsterModule.path("src/main/resources/static/css/application.css")).add(JHipsterModule.lineBeforeText(THYMELEAF_CSS_NEEDLE), TAILWINDCSS_SETUP)).and()).in(JHipsterModule.path("src/main/resources/templates/index.html")).add(EXISTING_WELCOME_THYMELEAF_MESSAGE_NEEDLE, TAILWINDCSS_WELCOME_THYMELEAF_MESSAGE)).and()).and().files().add(SOURCE.template(TAILWIND_CONFIG_JS), ROOT_DESTINATION.append(TAILWIND_CONFIG_JS)).add(RESOURCES_SOURCE.append(STATIC_IMAGES).file("ThymeleafLogo.png"), DESTINATION.append(STATIC_IMAGES).append("ThymeleafLogo.png")).and().build();
    }

    public JHipsterModule buildHtmxWebjarsModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).mandatoryReplacements().in(MAIN_RESOURCES_PATH.append(TEMPLATES_LAYOUT).append(MAIN_HTML)).add(JHipsterModule.lineBeforeText(MAIN_SCRIPT_NEEDLE), this.webjarsScriptTag("htmx.org/dist/htmx.min.js"))).and()).and().build();
    }

    public JHipsterModule buildAlpineWebjarsModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES, properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).mandatoryReplacements().in(MAIN_RESOURCES_PATH.append(TEMPLATES_LAYOUT).append(MAIN_HTML)).add(JHipsterModule.lineBeforeText(MAIN_SCRIPT_NEEDLE), this.webjarsScriptTag("alpinejs/dist/cdn.js"))).and()).and().build();
    }

    private String webjarsScriptTag(String webjarsLocation) {
        return "<script type=\"text/javascript\" th:src=\"@{/webjars/%s}\"></script>".formatted(webjarsLocation);
    }
}

